/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.ui.dialogs.RenameDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameFilesHandler
extends AbstractHandler {
    private static TreeViewer currentViewer;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection sel = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (!sel.isEmpty()) {
            IFSTreeNode node = (IFSTreeNode)sel.getFirstElement();
            boolean inPlaceEditor = UIPlugin.isInPlaceEditor();
            if (inPlaceEditor) {
                Control control;
                if (currentViewer != null && !(control = currentViewer.getControl()).isDisposed()) {
                    currentViewer.editElement((Object)node, 0);
                }
            } else {
                Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
                RenameDialog dialog = this.createRenameDialog(shell, node);
                int ok = dialog.open();
                if (ok == 0) {
                    UiExecutor.execute(node.operationRename(dialog.getNewName()));
                }
            }
        }
        return null;
    }

    private RenameDialog createRenameDialog(Shell shell, IFSTreeNode node) {
        String[] names = this.getUsedNames(node);
        String title = node.isFile() ? Messages.RenameFilesHandler_TitleRenameFile : (node.isDirectory() ? Messages.RenameFilesHandler_TitleRenameFolder : Messages.RenameFilesHandler_TitleRename);
        String formatRegex = node.isWindowsNode() ? "[^(\\?|\\\\|/|:|\\*|<|>|\\|)]+" : "[^/]+";
        String error = node.isWindowsNode() ? Messages.FSRenamingAssistant_WinIllegalCharacters : Messages.FSRenamingAssistant_UnixIllegalCharacters;
        String prompt = Messages.RenameFilesHandler_RenamePromptMessage;
        String usedError = Messages.FSRenamingAssistant_NameAlreadyExists;
        String label = Messages.RenameFilesHandler_PromptNewName;
        return new RenameDialog(shell, title, null, prompt, usedError, error, label, node.getName(), formatRegex, names, null);
    }

    private String[] getUsedNames(IFSTreeNode folder) {
        IFSTreeNode[] nodes = folder.getParent().getChildren();
        if (nodes == null) {
            return new String[0];
        }
        ArrayList<String> usedNames = new ArrayList<String>();
        IFSTreeNode[] iFSTreeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IFSTreeNode node = iFSTreeNodeArray[n2];
            usedNames.add(node.getName());
            ++n2;
        }
        return usedNames.toArray(new String[usedNames.size()]);
    }

    public static void setCurrentViewer(TreeViewer viewer) {
        currentViewer = viewer;
    }
}

