/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.actions.providers;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.ui.actions.providers.BasicActionProvider;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;

public abstract class AbstractValidationActionProvider
extends BasicActionProvider {
    public void fillSubMenu(IMenuManager subMenuManager) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean enabled = this.isEnabled(selection);
        this.populateActions(subMenuManager, selection, enabled);
    }

    protected abstract void populateActions(IMenuManager var1, IStructuredSelection var2, boolean var3);

    protected final boolean isEnabled(IStructuredSelection selection) {
        for (Object selectedObject : selection.toList()) {
            boolean enabled = this.isEnabled(selectedObject);
            if (!enabled) continue;
            return enabled;
        }
        return false;
    }

    protected boolean isEnabled(Object selectedObject) {
        if (selectedObject instanceof IContainer) {
            IContainer container = (IContainer)selectedObject;
            return ModelDescriptorRegistry.INSTANCE.getModels(container).size() > 0;
        }
        if (selectedObject instanceof IModelDescriptor) {
            return true;
        }
        IFile file = EcorePlatformUtil.getFile((Object)selectedObject);
        if (file != null) {
            return ModelDescriptorRegistry.INSTANCE.getModel(file) != null;
        }
        return false;
    }
}

