/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core.commands;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.remote.internal.proxy.core.ProxyConnection;
import org.eclipse.remote.internal.proxy.core.commands.AbstractCommand;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public class ExecCommand
extends AbstractCommand<Void> {
    private final DataOutputStream out;
    private final DataInputStream in;
    private final List<String> command;
    private final Map<String, String> env;
    private final String directory;
    private final boolean appendEnv;
    private final boolean redirect;
    private final int chanA;
    private final int chanB;
    private final int chanC;

    public ExecCommand(ProxyConnection conn, List<String> command, Map<String, String> env, String directory, boolean redirect, boolean appendEnv, int chanA, int chanB, int chanC) {
        super(conn);
        this.out = new DataOutputStream(conn.getCommandChannel().getOutputStream());
        this.in = new DataInputStream(conn.getCommandChannel().getInputStream());
        this.command = command;
        this.env = env;
        this.directory = directory;
        this.redirect = redirect;
        this.appendEnv = appendEnv;
        this.chanA = chanA;
        this.chanB = chanB;
        this.chanC = chanC;
    }

    @Override
    public Void call() throws ProxyException {
        try {
            this.out.writeByte(1);
            this.out.writeShort(101);
            this.out.writeByte(this.chanA);
            this.out.writeByte(this.chanB);
            this.out.writeByte(this.chanC);
            this.out.writeInt(this.command.size());
            for (String string : this.command) {
                this.out.writeUTF(string);
            }
            this.out.writeInt(this.env.size());
            for (Map.Entry entry : this.env.entrySet()) {
                this.out.writeUTF((String)entry.getKey());
                this.out.writeUTF((String)entry.getValue());
            }
            this.out.writeUTF(this.directory);
            this.out.writeBoolean(this.redirect);
            this.out.writeBoolean(this.appendEnv);
            this.out.flush();
            byte by = this.in.readByte();
            if (by != 0) {
                String errMsg = this.in.readUTF();
                System.err.println("exec command failed:" + errMsg);
                throw new ProxyException(errMsg);
            }
        }
        catch (IOException iOException) {
            throw new ProxyException(iOException.getMessage());
        }
        return null;
    }
}

