/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;

class AcceleratorBinding
implements Listener {
    private final MenuItem menuItem;
    private int accelerator;

    AcceleratorBinding(MenuItem menuItem) {
        this.menuItem = menuItem;
    }

    @Override
    public void handleEvent(Event event) {
        if (this.isRelevantEvent(event) && this.menuItem.isEnabled()) {
            this.menuItem.handleAcceleratorActivation();
            event.type = 0;
        }
    }

    int getAccelerator() {
        return this.accelerator;
    }

    void setAccelerator(int accelerator) {
        if (accelerator != this.accelerator) {
            int oldAccelerator = this.accelerator;
            this.accelerator = accelerator;
            if ((this.menuItem.style & 2) == 0) {
                this.updateDisplayActiveKeys(oldAccelerator, accelerator);
                this.updateDisplayFilter(oldAccelerator, accelerator);
            }
        }
    }

    void release() {
        this.setAccelerator(0);
    }

    private boolean isRelevantEvent(Event event) {
        boolean result = false;
        if (event.type == 1 && (this.accelerator & SWT.MODIFIER_MASK) == event.stateMask) {
            int key = this.accelerator & 0x100FFFF;
            result = event.character == '\u0000' ? event.keyCode == key : Character.toUpperCase(event.character) == Character.toUpperCase((char)key);
        }
        return result;
    }

    private void updateDisplayFilter(int oldAccelerator, int newAccelerator) {
        if (oldAccelerator == 0 && newAccelerator != 0) {
            this.menuItem.display.addFilter(1, this);
        } else if (oldAccelerator != 0 && newAccelerator == 0) {
            this.menuItem.display.removeFilter(1, this);
        }
    }

    private void updateDisplayActiveKeys(int oldAccelerator, int newAccelerator) {
        this.updateDisplayActiveKeys("org.eclipse.rap.rwt.activeKeys", oldAccelerator, newAccelerator);
        this.updateDisplayActiveKeys("org.eclipse.rap.rwt.cancelKeys", oldAccelerator, newAccelerator);
    }

    private void updateDisplayActiveKeys(String keysType, int oldAccelerator, int newAccelerator) {
        String[] oldActiveKeys = (String[])this.menuItem.display.getData(keysType);
        if (oldActiveKeys == null) {
            oldActiveKeys = new String[]{};
        }
        ArrayList<String> activeKeys = new ArrayList<String>(Arrays.asList(oldActiveKeys));
        if (oldAccelerator != 0) {
            activeKeys.remove(AcceleratorBinding.acceleratorAsString(oldAccelerator));
        }
        if (newAccelerator != 0) {
            activeKeys.add(AcceleratorBinding.acceleratorAsString(newAccelerator));
        }
        this.menuItem.display.setData(keysType, activeKeys.toArray(new String[0]));
    }

    private static String acceleratorAsString(int accelerator) {
        String result = "";
        if ((accelerator & 0x10000) != 0) {
            result = String.valueOf(result) + "ALT+";
        }
        if ((accelerator & 0x40000) != 0) {
            result = String.valueOf(result) + "CTRL+";
        }
        if ((accelerator & 0x20000) != 0) {
            result = String.valueOf(result) + "SHIFT+";
        }
        result = String.valueOf(result) + AcceleratorBinding.keyToString(accelerator & 0x100FFFF);
        return result;
    }

    private static String keyToString(int key) {
        String result;
        switch (key) {
            case 0x100000A: {
                result = "F1";
                break;
            }
            case 0x100000B: {
                result = "F2";
                break;
            }
            case 0x100000C: {
                result = "F3";
                break;
            }
            case 0x100000D: {
                result = "F4";
                break;
            }
            case 0x100000E: {
                result = "F5";
                break;
            }
            case 0x100000F: {
                result = "F6";
                break;
            }
            case 0x1000010: {
                result = "F7";
                break;
            }
            case 0x1000011: {
                result = "F8";
                break;
            }
            case 0x1000012: {
                result = "F9";
                break;
            }
            case 0x1000013: {
                result = "F10";
                break;
            }
            case 0x1000014: {
                result = "F11";
                break;
            }
            case 0x1000015: {
                result = "F12";
                break;
            }
            case 0x1000009: {
                result = "INSERT";
                break;
            }
            case 127: {
                result = "DEL";
                break;
            }
            case 0x1000007: {
                result = "HOME";
                break;
            }
            case 0x1000008: {
                result = "END";
                break;
            }
            case 0x1000001: {
                result = "ARROW_UP";
                break;
            }
            case 0x1000002: {
                result = "ARROW_DOWN";
                break;
            }
            case 0x1000003: {
                result = "ARROW_LEFT";
                break;
            }
            case 0x1000004: {
                result = "ARROW_RIGHT";
                break;
            }
            case 0x1000005: {
                result = "PAGE_UP";
                break;
            }
            case 0x1000006: {
                result = "PAGE_DOWN";
                break;
            }
            case 16777299: {
                result = "NUM_LOCK";
                break;
            }
            case 16777300: {
                result = "SCROLL_LOCK";
                break;
            }
            case 0x1000055: {
                result = "PAUSE";
                break;
            }
            case 16777303: {
                result = "PRINT_SCREEN";
                break;
            }
            case 16777298: {
                result = "CAPS_LOCK";
                break;
            }
            default: {
                result = Character.toString(Character.toUpperCase((char)key));
            }
        }
        return result;
    }
}

