/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.MappingAction;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class ClassDatumAnalysis
implements Adapter {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ClassDatum classDatum;
    protected final @NonNull DomainUsage domainUsage;
    protected final @NonNull ClassDatum elementalClassDatum;
    private @Nullable List<@NonNull Mapping> producedBy = null;
    private @Nullable List<@NonNull Mapping> requiredBy = null;
    private @Nullable List<@NonNull ClassDatumAnalysis> superClassDatumAnalyses = null;
    private List<@NonNull Property> multiOpposites = null;
    private final @NonNull Map<@NonNull Region, @NonNull List<@NonNull Node>> introducer2assignmentNodes = new HashMap<Region, List<Node>>();
    private final @NonNull Map<@NonNull MappingRegion, @NonNull List<@NonNull Node>> consumer2predicateNodes = new HashMap<MappingRegion, List<Node>>();
    private final @NonNull Map<@NonNull Region, @NonNull List<@NonNull Node>> producer2assignmentNodes = new HashMap<Region, List<Node>>();

    public static @Nullable ClassDatumAnalysis find(@NonNull ClassDatum classDatum) {
        return (ClassDatumAnalysis)ClassUtil.getAdapter(ClassDatumAnalysis.class, (Notifier)classDatum);
    }

    public static @NonNull ClassDatumAnalysis get(@NonNull Node node) {
        ClassDatum classDatum = RegionUtil.getClassDatum((Node)node);
        ClassDatumAnalysis adapter = (ClassDatumAnalysis)ClassUtil.getAdapter(ClassDatumAnalysis.class, (Notifier)classDatum);
        if (adapter == null) {
            adapter = RegionUtil.getScheduleManager(RegionUtil.getOwningRegion((Node)node)).getClassDatumAnalysis(classDatum);
        }
        return adapter;
    }

    public ClassDatumAnalysis(@NonNull ScheduleManager scheduleManager, @NonNull ClassDatum classDatum) {
        Class type;
        this.scheduleManager = scheduleManager;
        this.classDatum = classDatum;
        classDatum.eAdapters().add((Object)this);
        TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
        this.domainUsage = scheduleManager.getDomainUsage((Element)typedModel);
        Class elementType = type = classDatum.getCompleteClass().getPrimaryClass();
        while (elementType instanceof CollectionType) {
            elementType = ((CollectionType)elementType).getElementType();
        }
        this.elementalClassDatum = elementType == null || elementType == type || !(elementType instanceof Class) ? classDatum : scheduleManager.getClassDatum(elementType, typedModel);
    }

    public void addConsumption(@NonNull MappingRegion consumer, @NonNull Node consumingNode) {
        List<@NonNull Node> predicateNodes = this.consumer2predicateNodes.get(consumer);
        if (predicateNodes == null) {
            predicateNodes = new ArrayList<Node>();
            this.consumer2predicateNodes.put(consumer, predicateNodes);
        }
        if (!predicateNodes.contains(consumingNode)) {
            predicateNodes.add(consumingNode);
        }
    }

    public void addIntroduction(@NonNull Region introducer, @NonNull Node introducingNode) {
        List<@NonNull Node> assignmentNodes = this.introducer2assignmentNodes.get(introducer);
        if (assignmentNodes == null) {
            assignmentNodes = new ArrayList<Node>();
            this.introducer2assignmentNodes.put(introducer, assignmentNodes);
        }
        assert (!assignmentNodes.contains(introducingNode));
        assignmentNodes.add(introducingNode);
    }

    public void addProduction(@NonNull MappingRegion producer, @NonNull Node producingNode) {
        List<@NonNull Node> assignmentNodes = this.producer2assignmentNodes.get(producer);
        if (assignmentNodes == null) {
            assignmentNodes = new ArrayList<Node>();
            this.producer2assignmentNodes.put((Region)producer, assignmentNodes);
        }
        if (!assignmentNodes.contains(producingNode)) {
            assignmentNodes.add(producingNode);
        }
    }

    public @NonNull ClassDatum getClassDatum() {
        return this.classDatum;
    }

    public @NonNull Iterable<@NonNull Node> getConsumingNodes() {
        return Iterables.concat(this.consumer2predicateNodes.values());
    }

    public @NonNull List<@NonNull MappingRegion> getConsumingRegions() {
        return new ArrayList<MappingRegion>(this.consumer2predicateNodes.keySet());
    }

    public @NonNull DomainUsage getDomainUsage() {
        return this.domainUsage;
    }

    public @NonNull ClassDatum getElementalClassDatum() {
        return this.elementalClassDatum;
    }

    public @Nullable List<Property> getMultiOpposites() {
        List<@NonNull Property> multiOpposites2 = this.multiOpposites;
        if (multiOpposites2 == null) {
            EnvironmentFactory environmentFactory = this.scheduleManager.getEnvironmentFactory();
            CompleteClass completeClass = this.classDatum.getCompleteClass();
            assert (completeClass != null);
            for (Property property : completeClass.getProperties(null)) {
                Type childrenType;
                Property oppositeProperty = property.getOpposite();
                if (oppositeProperty == null || !oppositeProperty.isIsMany() || oppositeProperty.isIsDerived() || !((childrenType = oppositeProperty.getType()) instanceof CollectionType)) continue;
                Type childType = ((CollectionType)childrenType).getElementType();
                assert (childType != null);
                CompleteClass childCompleteClass = environmentFactory.getCompleteModel().getCompleteClass(childType);
                if (!completeClass.conformsTo(childCompleteClass)) continue;
                if (multiOpposites2 == null) {
                    this.multiOpposites = multiOpposites2 = new ArrayList<Property>();
                }
                multiOpposites2.add(oppositeProperty);
            }
            if (multiOpposites2 != null) {
                Collections.sort(multiOpposites2, QVTscheduleUtil.MultiOppositeComparator.INSTANCE);
            }
        }
        return multiOpposites2;
    }

    public @NonNull List<@NonNull Mapping> getProducedBy() {
        List<@NonNull Mapping> producedBy2 = this.producedBy;
        if (producedBy2 == null) {
            this.producedBy = producedBy2 = new ArrayList<Mapping>();
            for (MappingAction producingAction : ClassUtil.nullFree((EList)this.classDatum.getProducedByActions())) {
                Mapping mapping = producingAction.getReferredMapping();
                assert (mapping != null);
                producedBy2.add(mapping);
            }
        }
        return producedBy2;
    }

    public @NonNull Iterable<Node> getProducingNodes() {
        return Iterables.concat(this.consumer2predicateNodes.values());
    }

    public @NonNull Set<Region> getProducingRegions() {
        return this.producer2assignmentNodes.keySet();
    }

    public @NonNull List<@NonNull Mapping> getRequiredBy() {
        List<@NonNull Mapping> requiredBy2 = this.requiredBy;
        if (requiredBy2 == null) {
            this.requiredBy = requiredBy2 = new ArrayList<Mapping>();
            for (MappingAction consumingAction : ClassUtil.nullFree((EList)this.classDatum.getRequiredByActions())) {
                Mapping mapping = consumingAction.getReferredMapping();
                assert (mapping != null);
                requiredBy2.add(mapping);
            }
        }
        return requiredBy2;
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @Nullable Node getSingleProducer() {
        Iterator<List<Node>> values = this.producer2assignmentNodes.values().iterator();
        if (!values.hasNext()) {
            return null;
        }
        List<Node> firstProductions = values.next();
        return !values.hasNext() && firstProductions.size() == 1 ? firstProductions.get(0) : null;
    }

    public List<@NonNull ClassDatumAnalysis> getSuperClassDatumAnalyses() {
        List<@NonNull ClassDatumAnalysis> superClassDatumAnalyses2 = this.superClassDatumAnalyses;
        if (superClassDatumAnalyses2 == null) {
            this.superClassDatumAnalyses = superClassDatumAnalyses2 = new ArrayList<ClassDatumAnalysis>();
            CompleteClass completeClass = this.getClassDatum().getCompleteClass();
            for (CompleteClass completeSuperClass : completeClass.getSuperCompleteClasses()) {
                superClassDatumAnalyses2.add(this.scheduleManager.getClassDatumAnalysis(completeSuperClass, (TypedModel)ClassUtil.nonNullState((Object)this.domainUsage.getTypedModel((Element)completeClass))));
            }
        }
        return superClassDatumAnalyses2;
    }

    public Notifier getTarget() {
        return this.classDatum;
    }

    public boolean hasNoProducers() {
        return this.producer2assignmentNodes.size() == 0;
    }

    public String toString() {
        return this.classDatum.toString();
    }

    public boolean isAdapterForType(Object type) {
        return type == ClassDatumAnalysis.class;
    }

    public void notifyChanged(Notification notification) {
    }

    public void setTarget(Notifier newTarget) {
    }
}

