/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.core.model;

import java.util.Comparator;
import org.eclipse.ptp.rm.lml.core.elements.CellType;
import org.eclipse.ptp.rm.lml.core.elements.RowType;

public class TableSorter
implements Comparator<RowType> {
    private final int up;
    private final int sortIndex;
    private final int sortDirection;
    private final String sortType;
    private static final String intRegex = "^\\s*[\\+\\-]?[0-9]+$";

    public static boolean isInteger(String value) {
        return value.matches(intRegex);
    }

    public TableSorter(String sortType, int up, int sortIndex, int sortDirection) {
        this.up = up;
        this.sortIndex = sortIndex;
        this.sortDirection = sortDirection;
        this.sortType = sortType;
    }

    @Override
    public int compare(RowType a, RowType b) {
        CellType aCell = a.getCell().get(this.sortIndex);
        String aValue = null;
        if (aCell != null) {
            aValue = aCell.getValue();
        }
        CellType bCell = b.getCell().get(this.sortIndex);
        String bValue = null;
        if (bCell != null) {
            bValue = bCell.getValue();
        }
        if (aCell == null && bCell == null || aValue != null && aValue.equals("?") && bValue != null && bValue.equals("?")) {
            return 0;
        }
        if (aCell == null || aValue == null || aValue.equals("?")) {
            return this.sortDirection == this.up ? -1 : 1;
        }
        if (bCell == null || bValue == null || bValue.equals("?")) {
            return this.sortDirection == this.up ? 1 : -1;
        }
        if (aValue.equals(bValue)) {
            return 0;
        }
        if (this.sortType.equals("numeric")) {
            int aInt = 0;
            int bInt = 0;
            if (!TableSorter.isInteger(aValue)) {
                if (this.sortDirection == this.up) {
                    return -1;
                }
                return 1;
            }
            if (!TableSorter.isInteger(bValue)) {
                if (this.sortDirection == this.up) {
                    return 1;
                }
                return -1;
            }
            aInt = Integer.parseInt(aValue);
            bInt = Integer.parseInt(bValue);
            if (this.sortDirection == this.up) {
                return aInt < bInt ? -1 : 1;
            }
            return aInt < bInt ? 1 : -1;
        }
        if (this.sortDirection == this.up) {
            return aValue.compareTo(bValue) < 0 ? -1 : 1;
        }
        return aValue.compareTo(bValue) < 0 ? 1 : -1;
    }
}

