/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal.rulesengine;

import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.launch.RMLaunchUtils;
import org.eclipse.ptp.launch.internal.rulesengine.DownloadRule;
import org.eclipse.ptp.launch.rulesengine.IRuleAction;
import org.eclipse.remote.core.IRemoteFileService;

public class DownloadRuleAction
implements IRuleAction {
    private final DownloadRule fRule;
    private final ILaunchConfiguration fConfiguration;
    private final IProgressMonitor fMonitor;

    public DownloadRuleAction(ILaunchConfiguration configuration, DownloadRule rule, IProgressMonitor monitor) {
        this.fRule = rule;
        this.fConfiguration = configuration;
        this.fMonitor = monitor;
    }

    @Override
    public void run() throws CoreException {
        Assert.isNotNull((Object)this.fRule);
        Assert.isNotNull((Object)this.fConfiguration);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)this.fMonitor, (int)40);
        Path localParentPath = new Path(this.fRule.getLocalDirectory());
        if (!localParentPath.isAbsolute()) {
            IPath defaultPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            localParentPath = defaultPath.append((IPath)localParentPath);
        }
        localParentPath.removeTrailingSeparator();
        Assert.isTrue((boolean)localParentPath.isAbsolute(), (String)"localPath.isAbsolute()");
        IRemoteFileService localFileManager = RMLaunchUtils.getLocalFileService(this.fConfiguration);
        IFileStore localFileParentResource = localFileManager.getResource(localParentPath.toString());
        IFileInfo localFileParentInfo = localFileParentResource.fetchInfo(0, (IProgressMonitor)progress.newChild(5));
        if (!localFileParentInfo.exists()) {
            localFileParentResource.mkdir(0, (IProgressMonitor)progress.newChild(5));
        }
        IPath[] remotePaths = this.fRule.getRemoteFilesAsPathArray();
        IPath remoteWorkingPath = new Path(this.fConfiguration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", "")).removeLastSegments(1);
        IPath[] iPathArray = remotePaths;
        int n = remotePaths.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteFileService remoteFileManager;
            IFileStore remoteFileStore;
            IFileInfo remoteFileInfo;
            IPath remotePath2 = iPathArray[n2];
            progress.setWorkRemaining(100);
            IPath remotePath = remotePath2;
            if (!remotePath.isAbsolute()) {
                remotePath = remoteWorkingPath.append(remotePath);
            }
            if ((remoteFileInfo = (remoteFileStore = (remoteFileManager = RMLaunchUtils.getRemoteFileService(this.fConfiguration, (IProgressMonitor)progress.newChild(5))).getResource(remotePath.toString())).fetchInfo(0, (IProgressMonitor)progress.newChild(5))).exists()) {
                IPath localPath = localParentPath.append(remotePath.lastSegment());
                IFileStore localFileStore = localFileManager.getResource(localPath.toString());
                this.doDownload(remoteFileStore, remotePath, localFileStore, localPath, (IProgressMonitor)progress.newChild(20));
            }
            ++n2;
        }
    }

    private void doDownload(IFileStore remoteFileStore, IPath remotePath, IFileStore localFileStore, IPath localPath, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        try {
            IFileInfo localFileInfo = localFileStore.fetchInfo();
            IFileInfo remoteFileInfo = remoteFileStore.fetchInfo(0, (IProgressMonitor)progress.newChild(5));
            if (localFileInfo.exists()) {
                switch (this.fRule.getOverwritePolicy()) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        long dupFileModTime = localFileInfo.getLastModified();
                        long localFileModTime = remoteFileInfo.getLastModified();
                        if (dupFileModTime < localFileModTime) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            remoteFileStore.copy(localFileStore, 2, (IProgressMonitor)progress.newChild(5));
            boolean changedAttr = false;
            if (this.fRule.isAsReadOnly()) {
                localFileInfo.setAttribute(2, true);
                changedAttr = true;
            }
            if (this.fRule.isAsExecutable()) {
                localFileInfo.setAttribute(4, true);
                changedAttr = true;
            }
            if (changedAttr) {
                localFileStore.putInfo(localFileInfo, 1024, (IProgressMonitor)progress.newChild(5));
            }
            if (this.fRule.isPreserveTimeStamp()) {
                localFileInfo.setLastModified(remoteFileInfo.getLastModified());
                localFileStore.putInfo(localFileInfo, 2048, (IProgressMonitor)progress.newChild(5));
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

