/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.DataCache;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.InstructionCache;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.InstructionTraceCache;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.UnifiedCache;
import org.xml.sax.Attributes;

public class Cache {
    private String type;
    private int level;
    private int size;
    private int linesize;
    private int associativity;
    private String sizeUnits;
    private String associativityType;
    private static final String CACHETAG = "cache";
    private static final String SIZETAG = "size";
    private static final String LINESIZETAG = "linesize";
    private static final String ASSOCTAG = "associativity";
    private static final String TYPEATT = "type";
    private static final String LEVELATT = "level";
    private static final String UNITSATT = "units";
    private static final String DCACHE = "data";
    private static final String ICACHE = "instruction";
    private static final String ITRACECACHE = "instruction trace";
    private static final String UCACHE = "unified";
    private static final Set<String> keySet = new TreeSet<String>();
    private String tmpValue = "";

    static {
        keySet.add(CACHETAG);
        keySet.add(SIZETAG);
        keySet.add(LINESIZETAG);
        keySet.add(ASSOCTAG);
    }

    static boolean containsKey(String str) {
        return keySet.contains(str);
    }

    static Cache newInstance(String type) {
        if (type == null) {
            return new Cache();
        }
        if (type.equalsIgnoreCase(ICACHE)) {
            return new InstructionCache();
        }
        if (type.equalsIgnoreCase(DCACHE)) {
            return new DataCache();
        }
        if (type.equalsIgnoreCase(UCACHE)) {
            return new UnifiedCache();
        }
        if (type.equalsIgnoreCase(ITRACECACHE)) {
            return new InstructionTraceCache();
        }
        return new Cache();
    }

    Cache() {
    }

    void startElement(String uri, String localName, String qName, Attributes atts) {
        if (qName.equals(CACHETAG)) {
            this.type = atts.getValue(TYPEATT);
            String levelStr = atts.getValue(LEVELATT);
            this.level = Integer.parseInt(levelStr);
            if (this.level <= 0) {
                String str = "Wrong cache level value '" + levelStr + "' . Should be > 0.";
                throw new RuntimeException(str);
            }
        } else if (qName.equals(SIZETAG)) {
            this.sizeUnits = atts.getValue(UNITSATT);
        } else if (qName.equals(ASSOCTAG)) {
            this.associativityType = atts.getValue(TYPEATT);
        }
        this.tmpValue = "";
    }

    void characters(char[] ch, int start, int length) {
        String tmpString = new String(ch, start, length);
        if (tmpString.length() != 0) {
            this.tmpValue = this.tmpValue.length() == 0 ? tmpString : this.tmpValue.concat(tmpString);
        }
    }

    void endElement(String uri, String localName, String qName) {
        this.tmpValue = this.tmpValue.trim();
        if (qName.equals(SIZETAG)) {
            this.size = Integer.parseInt(this.tmpValue);
            if (this.size <= 0) {
                String str = "Wrong cache size value '" + this.tmpValue + "' . Should be > 0.";
                throw new RuntimeException(str);
            }
        } else if (qName.equals(LINESIZETAG)) {
            this.linesize = Integer.parseInt(this.tmpValue);
            if (this.linesize <= 0) {
                String str = "Wrong cache linesize value '" + this.tmpValue + "' . Should be > 0.";
                throw new RuntimeException(str);
            }
        } else if (qName.equals(ASSOCTAG)) {
            this.associativity = Integer.parseInt(this.tmpValue);
            if (this.associativity < 0) {
                String str = "Wrong cache associativity value '" + this.tmpValue + "' . Should be >= 0.";
                throw new RuntimeException(str);
            }
        }
        this.tmpValue = "";
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("size: " + this.size + " (" + this.sizeUnits + ")");
        res.append(", associativity: " + this.associativity + ", associativity type: \"" + this.associativityType + "\"");
        return res.toString();
    }

    public String getType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    public int getSize() {
        return this.size;
    }

    public String getSizeUnits() {
        return this.sizeUnits;
    }

    public int getLineSize() {
        return this.linesize;
    }

    public int getAssociativity() {
        return this.associativity;
    }

    public String getAssociativityType() {
        return this.associativityType;
    }
}

