/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.AbstractDBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpArrayValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpBoolValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpFloatValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpIntValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpNullValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpObjectValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpResourceValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStringValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpUninitializedValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpUnknownValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;

public class DBGpValueBuilder {
    public AbstractDBGpValue build(DBGpVariable variable) {
        AbstractDBGpValue value;
        switch (variable.getDataType()) {
            case PHP_ARRAY: {
                value = new DBGpArrayValue(variable);
                break;
            }
            case PHP_BOOL: {
                value = new DBGpBoolValue(variable);
                break;
            }
            case PHP_FLOAT: {
                value = new DBGpFloatValue(variable);
                break;
            }
            case PHP_INT: {
                value = new DBGpIntValue(variable);
                break;
            }
            case PHP_NULL: {
                value = new DBGpNullValue(variable);
                break;
            }
            case PHP_OBJECT: {
                value = new DBGpObjectValue(variable);
                break;
            }
            case PHP_RESOURCE: {
                value = new DBGpResourceValue(variable);
                break;
            }
            case PHP_STRING: {
                value = new DBGpStringValue(variable);
                break;
            }
            case PHP_UNINITIALIZED: {
                value = new DBGpUninitializedValue(variable);
                break;
            }
            default: {
                value = new DBGpUnknownValue(variable);
            }
        }
        value.update(variable.getDescriptor());
        return value;
    }
}

