/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.regex.Pattern;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;

public class ApiDescriptionModifier
extends ApiDescriptionVisitor {
    private Pattern[] fInternalPackages;
    private Pattern[] fApiPackages;
    private IApiDescription fDescription;

    public ApiDescriptionModifier(String[] internal, String[] api) {
        this.setInternalPatterns(internal);
        this.setApiPatterns(api);
    }

    public void setApiDescription(IApiDescription description) {
        this.fDescription = description;
    }

    private void setInternalPatterns(String[] patterns) {
        if (patterns == null || patterns.length == 0) {
            this.fInternalPackages = null;
        } else {
            this.fInternalPackages = new Pattern[patterns.length];
            int i = 0;
            while (i < patterns.length) {
                this.fInternalPackages[i] = Pattern.compile(patterns[i]);
                ++i;
            }
        }
    }

    private void setApiPatterns(String[] patterns) {
        if (patterns == null || patterns.length == 0) {
            this.fApiPackages = null;
        } else {
            this.fApiPackages = new Pattern[patterns.length];
            int i = 0;
            while (i < patterns.length) {
                this.fApiPackages[i] = Pattern.compile(patterns[i]);
                ++i;
            }
        }
    }

    @Override
    public boolean visitElement(IElementDescriptor element, IApiAnnotations description) {
        switch (element.getElementType()) {
            case 8: {
                return true;
            }
            case 1: {
                IPackageDescriptor pkg = (IPackageDescriptor)element;
                if (this.fInternalPackages != null && this.matchesPattern(pkg.getName(), this.fInternalPackages)) {
                    this.fDescription.setVisibility(element, 2);
                }
                if (this.fApiPackages != null && this.matchesPattern(pkg.getName(), this.fApiPackages)) {
                    this.fDescription.setVisibility(element, 1);
                }
                return false;
            }
        }
        return false;
    }

    private boolean matchesPattern(String name, Pattern[] patterns) {
        Pattern[] patternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            if (pattern.matcher(name).find()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

