/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EcoreUtils;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.TimeInterval;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class CustomTimeConstraintCreateCommand
extends EditElementCommand {
    public CustomTimeConstraintCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    public boolean canExecute() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        TimeConstraint timeConstraint = UMLFactory.eINSTANCE.createTimeConstraint();
        CreateElementRequest request = (CreateElementRequest)this.getRequest();
        EditPart originalTarget = (EditPart)request.getParameter("ORIGINAL_TARGET");
        NamedElement targetElement = (NamedElement)((View)originalTarget.getModel()).getElement();
        Package containingPackage = EcoreUtils.getContaining(request.getContainer(), Package.class);
        if (containingPackage == null) {
            return CommandResult.newErrorCommandResult((String)"The container must be in a Package");
        }
        Interaction containingInteraction = EcoreUtils.getContaining(request.getContainer(), Interaction.class);
        if (containingInteraction == null) {
            return CommandResult.newErrorCommandResult((String)"The container must be in an Interaction");
        }
        containingInteraction.getOwnedRules().add((Object)timeConstraint);
        timeConstraint.getConstrainedElements().clear();
        timeConstraint.getConstrainedElements().add((Object)targetElement);
        TimeInterval timeInterval = UMLFactory.eINSTANCE.createTimeInterval();
        timeConstraint.setSpecification((ValueSpecification)timeInterval);
        TimeExpression minTime = UMLFactory.eINSTANCE.createTimeExpression();
        TimeExpression maxTime = UMLFactory.eINSTANCE.createTimeExpression();
        containingPackage.getPackagedElements().add((Object)minTime);
        containingPackage.getPackagedElements().add((Object)maxTime);
        timeInterval.setMin((ValueSpecification)minTime);
        timeInterval.setMax((ValueSpecification)maxTime);
        LiteralString minExpr = UMLFactory.eINSTANCE.createLiteralString();
        LiteralString maxExpr = UMLFactory.eINSTANCE.createLiteralString();
        minTime.setExpr((ValueSpecification)minExpr);
        maxTime.setExpr((ValueSpecification)maxExpr);
        minExpr.setValue("t1");
        maxExpr.setValue("t2");
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)timeConstraint);
        return CommandResult.newOKCommandResult((Object)timeConstraint);
    }
}

