/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.parsers.CSVParser;
import org.eclipse.papyrus.infra.nattable.parsers.CellIterator;
import org.eclipse.papyrus.infra.nattable.parsers.RowIterator;
import org.eclipse.papyrus.infra.nattable.paste.IValueSetter;
import org.eclipse.papyrus.infra.nattable.paste.PastePostActionRegistry;
import org.eclipse.papyrus.infra.nattable.provider.AbstractPasteEObjectInNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.ExtendedCompoundCommand;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;

public class PasteEObjectAxisInNattableCommandProvider
extends AbstractPasteEObjectInNattableCommandProvider {
    private EStructuralFeature containmentFeature;
    private IElementType typeToCreate;

    public PasteEObjectAxisInNattableCommandProvider(INattableModelManager tableManager, boolean pasteColumn, Reader reader, CSVPasteHelper pasteHelper, long totalSize) {
        super(tableManager, pasteColumn, reader, pasteHelper, totalSize);
    }

    @Override
    protected CSVParser createParser() {
        return this.pasteHelper.createParser(this.reader);
    }

    @Override
    protected void init() {
        this.secondAxis = this.pasteColumn ? this.tableManager.getRowElementsList() : this.tableManager.getColumnElementsList();
        PasteEObjectConfiguration configuration = (PasteEObjectConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(this.table, NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), this.pasteColumn);
        if (configuration != null) {
            this.containmentFeature = configuration.getPasteElementContainementFeature();
            this.typeToCreate = ElementTypeRegistry.getInstance().getType(configuration.getPastedElementId());
            this.postActions = new ArrayList(configuration.getPostActions());
            this.detachedMode = configuration.isDetachedMode();
        }
    }

    @Override
    protected ICommand getPasteRowFromStringInDetachedModeCommand(final TransactionalEditingDomain contextEditingDomain, final TransactionalEditingDomain tableEditingDomain, final IProgressMonitor progressMonitor, final Map<Object, Object> sharedMap) {
        if (progressMonitor != null) {
            progressMonitor.beginTask(PASTE_ACTION_TASK_NAME, this.nbOperationsToDo);
        }
        final ArrayList<EObject> createdElements = new ArrayList<EObject>();
        EClass eClassToCreate = this.typeToCreate.getEClass();
        EFactory eFactory = eClassToCreate.getEPackage().getEFactoryInstance();
        int nbCreatedElements = 0;
        long readChar = 0L;
        long previousreadChar = 0L;
        RowIterator rowIter = this.parser.parse();
        while (rowIter.hasNext()) {
            CellIterator cellIter = (CellIterator)rowIter.next();
            if (!cellIter.hasNext()) continue;
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                progressMonitor.done();
                this.localDispose();
                return null;
            }
            previousreadChar = this.parser.getReadCharacters();
            if (progressMonitor != null && (readChar += this.parser.getReadCharacters() - previousreadChar) > 1000L) {
                readChar = 0L;
                progressMonitor.subTask(NLS.bind((String)"{0} {1} have been created.", (Object[])new Object[]{nbCreatedElements, this.typeToCreate.getEClass().getName()}));
                progressMonitor.worked(1000);
            }
            ++nbCreatedElements;
            EObject createdElement = eFactory.create(eClassToCreate);
            createdElements.add(createdElement);
            ++nbCreatedElements;
            for (String currentPostActions : this.postActions) {
                PastePostActionRegistry.INSTANCE.doPostAction(this.tableManager, currentPostActions, this.tableContext, createdElement, sharedMap, null);
            }
            Iterator secondAxisIterator = this.secondAxis.iterator();
            while (secondAxisIterator.hasNext() && cellIter.hasNext()) {
                Object currentAxis = secondAxisIterator.next();
                String valueAsString = (String)cellIter.next();
                Object columnObject = currentAxis;
                EObject rowObject = createdElement;
                boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnObject, rowObject, sharedMap, this.tableManager);
                if (!isEditable) continue;
                AbstractStringValueConverter converter = CellManagerFactory.INSTANCE.getOrCreateStringValueConverterClass(columnObject, rowObject, this.existingConverters, this.pasteHelper.getMultiValueSeparator(), this.tableManager);
                CellManagerFactory.INSTANCE.setStringValue(columnObject, rowObject, valueAsString, converter, sharedMap, this.tableManager);
            }
            while (cellIter.hasNext()) {
                cellIter.next();
            }
        }
        AbstractTransactionalCommand pasteCommand = new AbstractTransactionalCommand(tableEditingDomain, PASTE_COMMAND_NAME, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ExtendedCompoundCommand compoundCommand = new ExtendedCompoundCommand(Messages.PasteEObjectAxisInTableCommandProvider_PasteInTableCommandName);
                Collection<String> postActions = PasteEObjectAxisInNattableCommandProvider.this.getPostActions();
                Collection postActionsAddedByCellManagers = (Collection)sharedMap.get("additionnal_post_actions_to_conclude_paste");
                postActions.addAll(postActionsAddedByCellManagers);
                List cells = (List)sharedMap.get("cellsToAdd");
                List valueToSet = (List)sharedMap.get("referencesToSet");
                int nbTasks = 1;
                ++nbTasks;
                nbTasks += postActions.size();
                ++nbTasks;
                nbTasks += valueToSet.size();
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.done();
                        PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.beginTask(Messages.PasteEObjectAxisInTableCommandProvider_FinishingThePaste, nbTasks);
                }
                if (!createdElements.isEmpty()) {
                    compoundCommand.append(AddCommand.create((EditingDomain)contextEditingDomain, (Object)PasteEObjectAxisInNattableCommandProvider.this.tableContext, (Object)PasteEObjectAxisInNattableCommandProvider.this.containmentFeature, (Collection)createdElements));
                }
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.done();
                        PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                    progressMonitor.subTask(Messages.PasteEObjectAxisInTableCommandProvider_AddingElementToTheTable);
                }
                Command cmd = null;
                cmd = PasteEObjectAxisInNattableCommandProvider.this.pasteColumn ? PasteEObjectAxisInNattableCommandProvider.this.tableManager.getAddColumnElementCommand(createdElements) : PasteEObjectAxisInNattableCommandProvider.this.tableManager.getAddRowElementCommand(createdElements);
                if (cmd != null) {
                    compoundCommand.appendIfCanExecute(cmd);
                }
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.done();
                        PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                    progressMonitor.subTask(Messages.PasteEObjectAxisInTableCommandProvider_DoingAdditionalActions);
                }
                for (String currentPostActions : postActions) {
                    PastePostActionRegistry.INSTANCE.concludePostAction(PasteEObjectAxisInNattableCommandProvider.this.tableManager, currentPostActions, sharedMap);
                    progressMonitor.worked(1);
                }
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.done();
                        PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                    progressMonitor.subTask(Messages.PasteEObjectAxisInTableCommandProvider_LinkingReferencesToTheModel);
                }
                if (valueToSet.size() > 0) {
                    for (IValueSetter current : valueToSet) {
                        current.doSetValue((EditingDomain)contextEditingDomain);
                        if (progressMonitor == null) continue;
                        if (progressMonitor.isCanceled()) {
                            progressMonitor.done();
                            PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                            return CommandResult.newCancelledCommandResult();
                        }
                        progressMonitor.worked(1);
                    }
                }
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.done();
                        PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                }
                if (!cells.isEmpty()) {
                    compoundCommand.append(AddCommand.create((EditingDomain)tableEditingDomain, (Object)PasteEObjectAxisInNattableCommandProvider.this.table, (Object)NattablePackage.eINSTANCE.getTable_Cells(), (Collection)cells));
                }
                if (compoundCommand != null && !compoundCommand.isEmpty() && compoundCommand.canExecute()) {
                    tableEditingDomain.getCommandStack().execute((Command)compoundCommand);
                }
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
                PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                return CommandResult.newOKCommandResult();
            }
        };
        return pasteCommand;
    }

    @Override
    protected ICommand getPasteRowFromStringInAttachedModeCommand(final TransactionalEditingDomain contextEditingDomain, final TransactionalEditingDomain tableEditingDomain, final IProgressMonitor progressMonitor) {
        if (progressMonitor != null) {
            progressMonitor.beginTask(PASTE_ACTION_TASK_NAME, this.nbOperationsToDo);
        }
        final CreateElementRequest createRequest = new CreateElementRequest(contextEditingDomain, this.tableContext, this.typeToCreate, (EReference)this.containmentFeature);
        final IElementEditService tableContextCommandProvider = ElementEditServiceUtils.getCommandProvider((EObject)this.tableContext);
        AbstractTransactionalCommand pasteAllCommand = new AbstractTransactionalCommand(contextEditingDomain, PASTE_COMMAND_NAME, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ExtendedCompoundCommand compoundCommand = new ExtendedCompoundCommand(Messages.PasteEObjectAxisInTableCommandProvider_PasteInTableCommandName);
                ArrayList<IStatus> resultStatus = new ArrayList<IStatus>();
                long readChar = 0L;
                long previousreadChar = 0L;
                RowIterator rowIter = PasteEObjectAxisInNattableCommandProvider.this.parser.parse();
                int nbCreatedElements = 0;
                while (rowIter.hasNext()) {
                    CellIterator cellIter = (CellIterator)rowIter.next();
                    if (!cellIter.hasNext()) continue;
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        progressMonitor.done();
                        PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                        return CommandResult.newCancelledCommandResult();
                    }
                    previousreadChar = PasteEObjectAxisInNattableCommandProvider.this.parser.getReadCharacters();
                    if (progressMonitor != null && (readChar += PasteEObjectAxisInNattableCommandProvider.this.parser.getReadCharacters() - previousreadChar) > 1000L) {
                        readChar = 0L;
                        progressMonitor.subTask(NLS.bind((String)"{0} {1} have been created.", (Object[])new Object[]{PasteEObjectAxisInNattableCommandProvider.this.typeToCreate.getEClass().getName(), nbCreatedElements}));
                        progressMonitor.worked(1000);
                    }
                    ++nbCreatedElements;
                    ICommand commandCreation = tableContextCommandProvider.getEditCommand((IEditCommandRequest)createRequest);
                    if (!commandCreation.canExecute()) continue;
                    Command emfCommandCreation = GMFtoEMFCommandWrapper.wrap((ICommand)commandCreation);
                    emfCommandCreation.execute();
                    compoundCommand.append(emfCommandCreation);
                    CommandResult res = commandCreation.getCommandResult();
                    Object createdElement = res.getReturnValue();
                    Command addCommand = PasteEObjectAxisInNattableCommandProvider.this.pasteColumn ? PasteEObjectAxisInNattableCommandProvider.this.tableManager.getAddColumnElementCommand(Collections.singleton(createdElement)) : PasteEObjectAxisInNattableCommandProvider.this.tableManager.getAddRowElementCommand(Collections.singleton(createdElement));
                    if (addCommand != null) {
                        compoundCommand.append(addCommand);
                    }
                    Iterator secondAxisIterator = PasteEObjectAxisInNattableCommandProvider.this.secondAxis.iterator();
                    while (secondAxisIterator.hasNext() && cellIter.hasNext()) {
                        Object rowObject;
                        Object columnObject;
                        Object currentAxis = secondAxisIterator.next();
                        String valueAsString = (String)cellIter.next();
                        if (PasteEObjectAxisInNattableCommandProvider.this.pasteColumn) {
                            columnObject = createdElement;
                            rowObject = currentAxis;
                        } else {
                            columnObject = currentAxis;
                            rowObject = createdElement;
                        }
                        boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnObject, rowObject, PasteEObjectAxisInNattableCommandProvider.this.tableManager);
                        if (!isEditable) continue;
                        AbstractStringValueConverter converter = CellManagerFactory.INSTANCE.getOrCreateStringValueConverterClass(columnObject, rowObject, PasteEObjectAxisInNattableCommandProvider.this.existingConverters, PasteEObjectAxisInNattableCommandProvider.this.pasteHelper.getMultiValueSeparator(), PasteEObjectAxisInNattableCommandProvider.this.tableManager);
                        Command setValueCommand = CellManagerFactory.INSTANCE.getSetStringValueCommand(contextEditingDomain, columnObject, rowObject, valueAsString, converter, PasteEObjectAxisInNattableCommandProvider.this.tableManager);
                        IStatus commandStatus = PasteEObjectAxisInNattableCommandProvider.this.getStatusCommand(setValueCommand);
                        if (!commandStatus.isOK()) {
                            resultStatus.add(commandStatus);
                            continue;
                        }
                        if (setValueCommand == null) continue;
                        compoundCommand.append(setValueCommand);
                    }
                    while (cellIter.hasNext()) {
                        cellIter.next();
                    }
                }
                if (compoundCommand != null && !compoundCommand.isEmpty() && compoundCommand.canExecute()) {
                    tableEditingDomain.getCommandStack().execute((Command)compoundCommand);
                }
                progressMonitor.done();
                PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                if (resultStatus.isEmpty()) {
                    return CommandResult.newOKCommandResult();
                }
                MultiStatus resultingStatus = new MultiStatus("org.eclipse.papyrus.infra.nattable", 0, resultStatus.toArray(new IStatus[resultStatus.size()]), "The paste has been done, but we found some problems", null);
                return new CommandResult((IStatus)resultingStatus);
            }
        };
        return pasteAllCommand;
    }

    @Override
    protected void localDispose() {
        super.localDispose();
        this.typeToCreate = null;
        this.containmentFeature = null;
    }
}

