/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.databinding;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomBooleanStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomStyleValueCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.types.NotationTypesMap;

public class CustomChildFloatingLabelBooleanStyleObservableValue
extends CustomBooleanStyleObservableValue {
    private static final String FLOATING_LABEL = "FloatingLabel";

    public CustomChildFloatingLabelBooleanStyleObservableValue(View source, EditingDomain domain, String styleName) {
        super(source, domain, styleName);
    }

    protected Object doGetValue() {
        Object value = null;
        if (this.source instanceof View) {
            List floatingLabels = this.source.getChildren().stream().filter(child -> this.isFloatingLabel(child)).collect(Collectors.toList());
            for (View child2 : floatingLabels) {
                NamedStyle valueStyle = child2.getNamedStyle(this.styleClass, this.styleName);
                if (valueStyle == null) continue;
                value = valueStyle.eGet(this.styleFeature);
            }
        }
        return value;
    }

    private boolean isFloatingLabel(Object child) {
        return child instanceof DecorationNode && FLOATING_LABEL.equals(NotationTypesMap.instance.getHumanReadableType((View)child));
    }

    protected void doSetValue(Object value) {
        if (value instanceof Boolean && this.source instanceof Shape) {
            CompoundCommand cc = new CompoundCommand();
            for (Object child : this.source.getChildren()) {
                CustomStyleValueCommand command;
                if (!this.isFloatingLabel(child) || (command = new CustomStyleValueCommand((View)child, value, this.styleClass, this.styleFeature, this.styleName)) == null) continue;
                cc.append((Command)command);
            }
            this.domain.getCommandStack().execute((Command)cc);
            this.doGetValue();
        }
    }
}

