/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomStringStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusLabelEditPart;

public class RefreshTextAlignmentEditPolicy
extends GraphicalEditPolicyEx
implements IChangeListener {
    public static final String REFRESH_TEXT_ALIGNMENT_EDITPOLICY = "Refresh text alignment edit policy";
    protected IObservableValue styleObservable;
    private View view;

    public void activate() {
        this.view = (View)this.getHost().getModel();
        if (this.view == null) {
            return;
        }
        if (this.getHost() instanceof PapyrusLabelEditPart) {
            this.styleObservable = new CustomStringStyleObservableValue(this.view, EMFHelper.resolveEditingDomain((EObject)this.view), "textAlignment");
            this.styleObservable.addChangeListener((IChangeListener)this);
        }
        this.getHost().refresh();
    }

    public void deactivate() {
        if (this.styleObservable != null) {
            this.styleObservable.removeChangeListener((IChangeListener)this);
            this.styleObservable.dispose();
            this.styleObservable = null;
        }
    }

    public void handleChange(ChangeEvent event) {
        if (this.getHost() instanceof PapyrusLabelEditPart) {
            PapyrusLabelEditPart editPart = (PapyrusLabelEditPart)this.getHost();
            IFigure figure = editPart.getFigure();
            ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move");
            req.setEditParts((EditPart)editPart);
            req.setLocation(figure.getBounds().getLocation());
            Command command = editPart.getCommand((Request)req);
            if (command != null && command.canExecute()) {
                TransactionUtil.getEditingDomain((EObject)this.view).getCommandStack().execute(GEFtoEMFCommandWrapper.wrap((Command)command));
            }
        }
        this.getHost().refresh();
    }
}

