/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractProperty;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class ConstrainedProperty
extends AbstractProperty {
    protected final @NonNull Property property;
    protected ExpressionInOCL expression = null;

    public ConstrainedProperty(@NonNull Property property) {
        this.property = property;
    }

    @Override
    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        ExpressionInOCL expression2 = this.expression;
        if (expression2 == null) {
            LanguageExpression defaultSpecification = this.property.getOwnedExpression();
            if (defaultSpecification == null) {
                throw new InvalidValueException("No defaultExpression for '{0}'", this.property);
            }
            try {
                MetamodelManager metamodelManager = executor.getMetamodelManager();
                this.expression = expression2 = metamodelManager.parseSpecification(defaultSpecification);
            }
            catch (ParserException e) {
                throw new InvalidValueException(e, "Bad defaultExpression for '{0}'", this.property);
            }
        }
        PivotUtil.checkExpression(expression2);
        EvaluationEnvironment nestedEvaluationEnvironment = executor.pushEvaluationEnvironment(expression2, null);
        Variable contextVariable = expression2.getOwnedContext();
        if (contextVariable != null) {
            nestedEvaluationEnvironment.add(contextVariable, sourceValue);
        }
        try {
            OCLExpression bodyExpression = expression2.getOwnedBody();
            assert (bodyExpression != null);
            Object object = executor.evaluate(bodyExpression);
            return object;
        }
        finally {
            executor.popEvaluationEnvironment();
        }
    }
}

