/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicArray<E> {
    private Object[] elements = new Object[0];

    public int add(E element) {
        int length = this.elements.length;
        int i = 0;
        while (i < length) {
            if (this.elements[i] == null) {
                this.elements[i] = element;
                return i;
            }
            ++i;
        }
        this.grow(length);
        this.elements[length] = element;
        return length;
    }

    public E add(int index, E element) {
        this.grow(index);
        Object old = this.elements[index];
        this.elements[index] = element;
        return (E)old;
    }

    public E remove(int index) {
        Object old = this.elements[index];
        if (old != null) {
            this.elements[index] = null;
            this.shrink();
        }
        return (E)old;
    }

    public E get(int index) {
        return (E)this.elements[index];
    }

    private void grow(int index) {
        if (index >= this.elements.length) {
            Object[] newChannels = new Object[index + 1];
            System.arraycopy(this.elements, 0, newChannels, 0, this.elements.length);
            this.elements = newChannels;
        }
    }

    private void shrink() {
        boolean shrink = false;
        int lastIndex = this.elements.length - 1;
        while (lastIndex > 0 && (shrink = this.elements[lastIndex] == null)) {
            --lastIndex;
        }
        if (shrink) {
            int newLength = lastIndex + 1;
            Object[] newChannels = new Object[newLength];
            System.arraycopy(this.elements, 0, newChannels, 0, newLength);
            this.elements = newChannels;
        }
    }
}

