/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class PasswordTextPainter
extends TextPainter {
    private Character echoChar = Character.valueOf('\u2022');

    public PasswordTextPainter() {
    }

    public PasswordTextPainter(boolean wrapText, boolean paintBg) {
        super(wrapText, paintBg);
    }

    public PasswordTextPainter(boolean wrapText, boolean paintBg, int spacing) {
        super(wrapText, paintBg, spacing);
    }

    public PasswordTextPainter(boolean wrapText, boolean paintBg, boolean calculate) {
        super(wrapText, paintBg, calculate);
    }

    public PasswordTextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculate) {
        super(wrapText, paintBg, spacing, calculate);
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
        Character configEchoChar = cellStyle.getAttributeValue(CellStyleAttributes.PASSWORD_ECHO_CHAR);
        if (configEchoChar != null) {
            this.echoChar = configEchoChar;
        }
        super.paintCell(cell, gc, rectangle, configRegistry);
    }

    @Override
    protected String getTextToDisplay(ILayerCell cell, GC gc, int availableLength, String text) {
        String result = super.getTextToDisplay(cell, gc, availableLength, text);
        return result.replaceAll(".", this.echoChar.toString());
    }
}

