/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.ibmvm.acquire.IBMDumpProvider;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IBMHeapDumpProvider
extends IBMDumpProvider {
    IBMHeapDumpProvider() {
    }

    String dumpName() {
        return "heapdump.YYmmdd.HHMMSS.%pid%.seq.phd";
    }

    int files() {
        return 2;
    }

    long averageFileSize(Collection<File> files) {
        long l1 = 0L;
        int i1 = 0;
        long l2 = 0L;
        int i2 = 0;
        for (File f : files) {
            if (!f.isFile()) continue;
            String s = f.getName();
            if (s.endsWith(".phd")) {
                l1 += f.length();
                ++i1;
                continue;
            }
            if (!s.endsWith(".txt")) continue;
            l2 += f.length();
            ++i2;
        }
        if (i1 > 0 && i2 > 0) {
            return (l1 / (long)i1 + l2 / (long)i2) / 2L;
        }
        if (i1 > 0) {
            return l1 / (long)i1;
        }
        if (i2 > 0) {
            return l2 / (long)i2;
        }
        return 10000000L;
    }

    public File jextract(File preferredDump, boolean compress, List<File> dumps, File udir, File javahome, IProgressListener listener) throws IOException, InterruptedException, SnapshotException {
        File result = this.mergeFileNames(preferredDump, dumps.get(0));
        if (compress && !result.getName().endsWith(".gz")) {
            result = new File(String.valueOf(result.getPath()) + ".gz");
        }
        for (File dump : dumps) {
            String name = dump.getName();
            if (name.contains("heapdump") || name.contains("javacore")) continue;
            return super.jextract(preferredDump, compress, dumps, udir, javahome, listener);
        }
        boolean zip = result.getName().endsWith(".gz");
        if (zip) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(dumps.get(0)));
            try {
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(result)));
                    try {
                        int c;
                        while ((c = ((InputStream)is).read()) >= 0) {
                            ((OutputStream)os).write(c);
                        }
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                }
                catch (IOException iOException) {
                    File file = super.jextract(preferredDump, compress, dumps, udir, javahome, listener);
                    ((InputStream)is).close();
                    return file;
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }
        int renamed = 0;
        int i = zip ? 1 : 0;
        while (i < dumps.size()) {
            File dest;
            File dump = dumps.get(i);
            if (i == 0) {
                dest = result;
            } else {
                String name1 = result.getName();
                String name2 = dumps.get(i).getName();
                int e1 = name1.lastIndexOf(46);
                int e2 = name2.lastIndexOf(46);
                String name = e1 >= 0 && e2 >= 0 ? String.valueOf(name1.substring(0, e1)) + name2.substring(e2) : name2;
                dest = new File(result.getParentFile(), name);
            }
            boolean rn = dump.renameTo(dest);
            if (rn) {
                ++renamed;
            } else if (renamed == 0) {
                return super.jextract(preferredDump, compress, dumps, udir, javahome, listener);
            }
            ++i;
        }
        if (zip) {
            dumps.get(0).delete();
        }
        return result;
    }
}

