/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.internal;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.launchbar.core.ILaunchDescriptorType;
import org.eclipse.launchbar.core.internal.Activator;

public class LaunchDescriptorTypeInfo {
    private final String id;
    private int priority;
    private IConfigurationElement element;
    private ILaunchDescriptorType type;
    private Expression expression;

    public LaunchDescriptorTypeInfo(IConfigurationElement element) {
        this.id = element.getAttribute("id");
        String priorityStr = element.getAttribute("priority");
        this.priority = 1;
        if (priorityStr != null) {
            try {
                this.priority = Integer.parseInt(priorityStr);
            }
            catch (NumberFormatException e) {
                Activator.log(e);
            }
        }
        this.element = element;
        IConfigurationElement[] enabledExpressions = element.getChildren("enablement");
        if (enabledExpressions == null || enabledExpressions.length == 0) {
            Activator.log((IStatus)new Status(2, "org.eclipse.launchbar.core", "Enablement expression is missing for descriptor type " + this.id));
        } else if (enabledExpressions.length > 1) {
            Activator.log((IStatus)new Status(2, "org.eclipse.launchbar.core", "Multiple enablement expressions are detected for descriptor type " + this.id));
        } else {
            try {
                this.expression = ExpressionConverter.getDefault().perform(enabledExpressions[0]);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
            if (this.expression == null) {
                Activator.log((IStatus)new Status(4, "org.eclipse.launchbar.core", "Cannot parse enablement expression defined in descriptor type " + this.id));
            }
        }
    }

    LaunchDescriptorTypeInfo(String id, int priority, ILaunchDescriptorType type) {
        this.id = id;
        this.priority = priority;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public ILaunchDescriptorType getType() throws CoreException {
        if (this.type == null) {
            this.type = (ILaunchDescriptorType)this.element.createExecutableExtension("class");
            this.element = null;
        }
        return this.type;
    }

    public boolean enabled(Object launchObject) throws CoreException {
        if (this.expression == null) {
            return true;
        }
        EvaluationContext context = new EvaluationContext(null, launchObject);
        context.setAllowPluginActivation(true);
        EvaluationResult result = this.expression.evaluate((IEvaluationContext)context);
        return result == EvaluationResult.TRUE;
    }
}

