/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.figures.processes;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public abstract class BorderAnchor
extends AbstractConnectionAnchor {
    public BorderAnchor(IFigure figure) {
        super(figure);
    }

    public Point getNearestPoint(Point reference, Point[] points) {
        Point resultPoint = null;
        double nearestDistance = Double.POSITIVE_INFINITY;
        Point[] pointArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point point = pointArray[n2];
            double distance = reference.getDistance(point);
            if (distance < nearestDistance) {
                nearestDistance = distance;
                resultPoint = point;
            }
            ++n2;
        }
        return resultPoint;
    }

    public Point getLocation(Point reference) {
        Rectangle bounds = Rectangle.SINGLETON.setBounds(this.getOwner().getBounds());
        this.getOwner().translateToAbsolute((Translatable)bounds);
        return this.getNearestPoint(reference, this.getPoints(bounds));
    }

    public abstract Point[] getPoints(Rectangle var1);

    public Point getTopPoint(Rectangle bounds, int delta) {
        return new Point(bounds.x + delta, bounds.y);
    }

    public Point getBottomPoint(Rectangle bounds, int delta) {
        return new Point(bounds.x + delta, bounds.y + bounds.height);
    }

    public Point getLeftPoint(Rectangle bounds, int delta) {
        return new Point(bounds.x, bounds.y + delta);
    }

    public Point getRightPoint(Rectangle bounds, int delta) {
        return new Point(bounds.x + bounds.width, bounds.y + delta);
    }
}

