/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.BlockBox;
import org.eclipse.jst.pagedesigner.css2.layout.FlowBox;
import org.eclipse.jst.pagedesigner.css2.layout.LineBox;
import org.eclipse.jst.pagedesigner.css2.layout.TextFragmentBox;
import org.eclipse.swt.graphics.Color;

public class BoxUtil {
    public static void setupBorderPaddingMargin(FlowBox box, ICSSStyle style) {
        box.setMarginInsets(new Insets(style.getMarginInsets()));
        box.setBorderInsets(new Insets(style.getBorderInsets()));
        box.setPaddingInsets(new Insets(style.getPaddingInsets()));
        if (box.getBorderPaddingHeight() > box.getHeight()) {
            box.setHeight(box.getBorderPaddingHeight());
        }
        if (box.getBorderPaddingWidth() > box.getWidth()) {
            box.setWidth(box.getBorderPaddingWidth());
        }
    }

    public static void drawBox(Graphics g, FlowBox box) {
        Color color = null;
        if (!(box instanceof BlockBox)) {
            color = box instanceof LineBox ? ColorConstants.blue : (box instanceof TextFragmentBox ? ColorConstants.green : ColorConstants.darkGreen);
        }
        if (color != null) {
            g.setForegroundColor(color);
            g.setLineStyle(2);
            g.setLineWidth(1);
            g.drawRectangle(box._x, box._y, box.getWidth(), box.getHeight());
        }
    }
}

