/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.context;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.source.ISymbolSourceProvider;
import org.eclipse.jst.jsf.context.symbol.source.ISymbolSourceProviderFactory;
import org.eclipse.jst.jsf.designtime.context.AbstractDTExternalContext;

public class DTJSPExternalContext
extends AbstractDTExternalContext {
    private final IFile _jspFile;

    /*
     * Enabled aggressive block sorting
     */
    protected DTJSPExternalContext(IAdaptable jspFile) {
        if (jspFile instanceof IFile) {
            this._jspFile = (IFile)jspFile;
            return;
        }
        if (jspFile == null) {
            this._jspFile = null;
            throw new AssertionError((Object)"jspFile must be adapable to an IFile");
        }
        IFile file = (IFile)jspFile.getAdapter(IFile.class);
        if (file != null) {
            this._jspFile = file;
            return;
        }
        this._jspFile = null;
        throw new AssertionError((Object)"jspFile must be adapable to an IFile");
    }

    protected Map doGetMapForScope(int scopeMask) {
        HashMap<String, ISymbol> map = new HashMap<String, ISymbol>();
        for (ISymbolSourceProviderFactory factory : JSFCommonPlugin.getSymbolSourceProviders()) {
            ISymbolSourceProvider provider = factory.createInstance(this._jspFile.getProject());
            ISymbol[] symbols = provider.getSymbols((IAdaptable)this._jspFile, scopeMask);
            int i = 0;
            while (i < symbols.length) {
                map.put(symbols[i].getName(), symbols[i]);
                ++i;
            }
        }
        return map;
    }

    public final void trace(PrintStream stream) {
        String[] scopeNames = new String[]{"request", "session", "application", "none"};
        Map[] symbolMaps = new Map[]{this.getRequestMap(), this.getSessionMap(), this.getApplicationMap(), this.getNoneMap()};
        int i = 0;
        while (i < scopeNames.length) {
            stream.println("--------------");
            stream.println(String.valueOf(scopeNames[i]) + " Scope:");
            stream.println("--------------");
            for (ISymbol symbol : symbolMaps[i].values()) {
                System.out.println(symbol.getName());
            }
            ++i;
        }
    }

    public String getRequestContextPath() {
        WebArtifactEdit artifactEdit = null;
        String path = null;
        try {
            artifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this._jspFile.getProject());
            path = artifactEdit.getServerContextRoot();
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return path;
    }
}

