/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.types;

import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;

public class TypeCoercer {
    public static String coerceToNumber(String boxedTypeSignature) throws TypeCoercionException {
        String boxedTypeSignature_ = boxedTypeSignature;
        if (Signature.getTypeSignatureKind((String)boxedTypeSignature_) == 4) {
            throw new TypeCoercionException("Cannot coerce arrays to numbers");
        }
        if ("Ljava.lang.Character".equals(boxedTypeSignature)) {
            boxedTypeSignature_ = "Ljava.lang.Short;";
        }
        if (TypeCoercer.typeIsNumeric(boxedTypeSignature_) || TypeCoercer.typeIsNull(boxedTypeSignature_)) {
            return boxedTypeSignature_;
        }
        if (TypeCoercer.typeIsString(boxedTypeSignature_)) {
            return null;
        }
        throw new TypeCoercionException();
    }

    public static boolean canCoerceToBoolean(String boxedTypeSignature) {
        return TypeCoercer.typeIsBoolean(boxedTypeSignature) || TypeCoercer.typeIsString(boxedTypeSignature) || TypeCoercer.typeIsNull(boxedTypeSignature);
    }

    public static boolean typeIsNumeric(String typeSignature) {
        return "Ljava.lang.Byte;".equals(typeSignature) || "Ljava.lang.Short;".equals(typeSignature) || "Ljava.lang.Integer;".equals(typeSignature) || "Ljava.lang.Long;".equals(typeSignature) || "Ljava.lang.Float;".equals(typeSignature) || "Ljava.lang.Double;".equals(typeSignature) || "Ljava.math.BigInteger;".equals(typeSignature) || "Ljava.math.BigDecimal;".equals(typeSignature);
    }

    public static boolean typeIsString(String typeSignature) {
        return "Ljava.lang.String;".equals(typeSignature);
    }

    public static boolean typeIsBoolean(String typeSignature) {
        return "Ljava.lang.Boolean;".equals(typeSignature);
    }

    public static boolean typeIsNull(String typeSignature) {
        return "V".equals(typeSignature);
    }
}

