/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;

public class FilteringIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> iterator;
    private final Predicate<? super E> predicate;
    private E next;
    private boolean done;

    public FilteringIterator(Iterator<? extends E> iterator, Predicate<? super E> predicate) {
        if (iterator == null || predicate == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator;
        this.predicate = predicate;
        this.loadNext();
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public E next() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        E result = this.next;
        this.loadNext();
        return result;
    }

    private void loadNext() {
        this.done = true;
        while (this.iterator.hasNext() && this.done) {
            E temp = this.iterator.next();
            if (this.predicate.evaluate(temp)) {
                this.next = temp;
                this.done = false;
                continue;
            }
            this.next = null;
            this.done = true;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.iterator);
    }
}

