/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.CharacterStringExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ExpressionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class ConversionDeclarationAnnotationElementAdapter<T>
implements DeclarationAnnotationElementAdapter<T> {
    protected final DeclarationAnnotationElementAdapter<Expression> adapter;
    protected final ExpressionConverter<T> converter;

    public ConversionDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, ExpressionConverter<T> converter) {
        this(new ExpressionDeclarationAnnotationElementAdapter<Expression>(annotationAdapter), converter);
    }

    public ConversionDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<T> converter) {
        this(new ExpressionDeclarationAnnotationElementAdapter<Expression>(annotationAdapter, elementName), converter);
    }

    public ConversionDeclarationAnnotationElementAdapter(DeclarationAnnotationElementAdapter<Expression> adapter, ExpressionConverter<T> converter) {
        this.adapter = adapter;
        this.converter = converter;
    }

    @Override
    public T getValue(ModifiedDeclaration declaration) {
        Expression expression = this.adapter.getValue(declaration);
        return this.converter.convert(expression);
    }

    @Override
    public T getValue(Annotation astAnnotation) {
        Expression expression = this.adapter.getValue(astAnnotation);
        return this.converter.convert(expression);
    }

    @Override
    public void setValue(T value, ModifiedDeclaration declaration) {
        Expression expression;
        try {
            expression = this.converter.convert(value, declaration.getAst());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        this.adapter.setValue(expression, declaration);
    }

    @Override
    public Expression getExpression(ModifiedDeclaration declaration) {
        return this.adapter.getExpression(declaration);
    }

    @Override
    public Expression getExpression(Annotation astAnnotation) {
        return this.adapter.getExpression(astAnnotation);
    }

    @Override
    public ASTNode getAstNode(ModifiedDeclaration declaration) {
        return this.adapter.getAstNode(declaration);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.adapter);
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forStrings(DeclarationAnnotationAdapter annotationAdapter) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, StringExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forStrings(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, StringExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<Integer> forNumbers(DeclarationAnnotationAdapter annotationAdapter) {
        return new ConversionDeclarationAnnotationElementAdapter<Integer>(annotationAdapter, NumberIntegerExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<Integer> forNumbers(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<Integer>(annotationAdapter, elementName, NumberIntegerExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<Boolean> forBooleans(DeclarationAnnotationAdapter annotationAdapter) {
        return new ConversionDeclarationAnnotationElementAdapter<Boolean>(annotationAdapter, BooleanExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<Boolean> forBooleans(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<Boolean>(annotationAdapter, elementName, BooleanExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forCharacters(DeclarationAnnotationAdapter annotationAdapter) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, CharacterStringExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forCharacters(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, CharacterStringExpressionConverter.instance());
    }
}

