/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassModifier;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSPropertyFileModifier;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.EscapeBackslashCompletionProposal;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesAssistContext;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEditorMessages;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEscapes;
import org.eclipse.jdt.internal.ui.text.correction.proposals.EditAnnotator;
import org.eclipse.jdt.ui.text.java.correction.CUCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ChangeCorrectionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;

public class PropertiesQuickAssistProcessor {
    public static boolean hasAssists(PropertiesAssistContext invocationContext) {
        try {
            return PropertiesQuickAssistProcessor.getEscapeUnescapeBackslashProposals((IQuickAssistInvocationContext)invocationContext, null) || PropertiesQuickAssistProcessor.getCreateFieldsInAccessorClassProposals(invocationContext, null) || PropertiesQuickAssistProcessor.getRemovePropertiesProposals(invocationContext, null) || PropertiesQuickAssistProcessor.getRenameKeysProposals(invocationContext, null);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        catch (BadPartitioningException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    public static ICompletionProposal[] collectAssists(PropertiesAssistContext invocationContext) throws BadLocationException, BadPartitioningException {
        ArrayList<ICompletionProposal> resultingCollections = new ArrayList<ICompletionProposal>();
        PropertiesQuickAssistProcessor.getEscapeUnescapeBackslashProposals((IQuickAssistInvocationContext)invocationContext, resultingCollections);
        PropertiesQuickAssistProcessor.getCreateFieldsInAccessorClassProposals(invocationContext, resultingCollections);
        PropertiesQuickAssistProcessor.getRemovePropertiesProposals(invocationContext, resultingCollections);
        PropertiesQuickAssistProcessor.getRenameKeysProposals(invocationContext, resultingCollections);
        if (resultingCollections.size() == 0) {
            return null;
        }
        return resultingCollections.toArray(new ICompletionProposal[resultingCollections.size()]);
    }

    private static boolean getEscapeUnescapeBackslashProposals(IQuickAssistInvocationContext invocationContext, ArrayList<ICompletionProposal> resultingCollections) throws BadLocationException, BadPartitioningException {
        String text;
        int proposalLength;
        int proposalOffset;
        ISourceViewer sourceViewer = invocationContext.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        Point selectedRange = sourceViewer.getSelectedRange();
        int selectionOffset = selectedRange.x;
        int selectionLength = selectedRange.y;
        if (selectionLength == 0) {
            char ch;
            if (selectionOffset != document.getLength() && ((ch = document.getChar(selectionOffset)) == '=' || ch == ':')) {
                return false;
            }
            ITypedRegion partition = null;
            if (document instanceof IDocumentExtension3) {
                partition = ((IDocumentExtension3)document).getPartition("___pf_partitioning", invocationContext.getOffset(), false);
            }
            if (partition == null) {
                return false;
            }
            String type = partition.getType();
            if (!type.equals("__pf_roperty_value") && !type.equals("__dftl_partition_content_type")) {
                return false;
            }
            proposalOffset = partition.getOffset();
            proposalLength = partition.getLength();
            text = document.get(proposalOffset, proposalLength);
            if (type.equals("__pf_roperty_value")) {
                text = text.substring(1);
                ++proposalOffset;
                --proposalLength;
            }
        } else {
            proposalOffset = selectionOffset;
            proposalLength = selectionLength;
            text = document.get(proposalOffset, proposalLength);
        }
        if (PropertiesFileEscapes.containsUnescapedBackslash(text)) {
            if (resultingCollections == null) {
                return true;
            }
            resultingCollections.add(new EscapeBackslashCompletionProposal(PropertiesFileEscapes.escape(text, false, true, false), proposalOffset, proposalLength, PropertiesFileEditorMessages.EscapeBackslashCompletionProposal_escapeBackslashes));
            return true;
        }
        if (PropertiesFileEscapes.containsEscapedBackslashes(text)) {
            if (resultingCollections == null) {
                return true;
            }
            resultingCollections.add(new EscapeBackslashCompletionProposal(PropertiesFileEscapes.unescapeBackslashes(text), proposalOffset, proposalLength, PropertiesFileEditorMessages.EscapeBackslashCompletionProposal_unescapeBackslashes));
            return true;
        }
        return false;
    }

    private static boolean getCreateFieldsInAccessorClassProposals(PropertiesAssistContext invocationContext, ArrayList<ICompletionProposal> resultingCollections) throws BadLocationException, BadPartitioningException {
        IDocument document = invocationContext.getDocument();
        int selectionOffset = invocationContext.getOffset();
        int selectionLength = invocationContext.getLength();
        ArrayList<String> fields = new ArrayList<String>();
        IType accessorClass = invocationContext.getAccessorType();
        if (accessorClass == null || !PropertiesQuickAssistProcessor.isEclipseNLSUsed(accessorClass)) {
            return false;
        }
        List<String> keys = PropertiesQuickAssistProcessor.getKeysFromSelection(document, selectionOffset, selectionLength);
        if (keys == null || keys.size() == 0) {
            return false;
        }
        for (String key : keys) {
            IField field;
            if (!PropertiesQuickAssistProcessor.isValidJavaIdentifier(key) || (field = accessorClass.getField(key)).exists()) continue;
            if (resultingCollections == null) {
                return true;
            }
            fields.add(key);
        }
        if (fields.size() == 0) {
            return false;
        }
        ICompilationUnit cu = accessorClass.getCompilationUnit();
        try {
            Change change = AccessorClassModifier.addFields(cu, fields);
            String name = Messages.format(fields.size() == 1 ? PropertiesFileEditorMessages.PropertiesCorrectionProcessor_create_field_in_accessor_label : PropertiesFileEditorMessages.PropertiesCorrectionProcessor_create_fields_in_accessor_label, BasicElementLabels.getFileName((ITypeRoot)cu));
            resultingCollections.add(new CUCorrectionProposal(name, cu, (TextChange)change, 5, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif")));
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return false;
        }
        return true;
    }

    private static boolean isValidJavaIdentifier(String key) {
        if (!Character.isJavaIdentifierStart(key.charAt(0))) {
            return false;
        }
        int i = 1;
        int length = key.length();
        while (i < length) {
            if (!Character.isJavaIdentifierPart(key.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean getRemovePropertiesProposals(PropertiesAssistContext invocationContext, ArrayList<ICompletionProposal> resultingCollections) throws BadLocationException, BadPartitioningException {
        IDocument document = invocationContext.getDocument();
        int selectionOffset = invocationContext.getOffset();
        int selectionLength = invocationContext.getLength();
        ArrayList<String> fields = new ArrayList<String>();
        IFile file = invocationContext.getFile();
        if (file == null) {
            return false;
        }
        IType accessorClass = invocationContext.getAccessorType();
        if (accessorClass == null || !PropertiesQuickAssistProcessor.isEclipseNLSUsed(accessorClass)) {
            return false;
        }
        List<String> keys = PropertiesQuickAssistProcessor.getKeysFromSelection(document, selectionOffset, selectionLength);
        if (keys == null || keys.size() == 0) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        for (String key : keys) {
            IField field = accessorClass.getField(key);
            if (!field.exists()) continue;
            fields.add(key);
        }
        ICompilationUnit cu = accessorClass.getCompilationUnit();
        try {
            Change[] changes;
            Change propertiesFileChange = NLSPropertyFileModifier.removeKeys(file.getFullPath(), keys);
            if (fields.size() > 0) {
                Change accessorChange = AccessorClassModifier.removeFields(cu, fields);
                changes = new Change[]{propertiesFileChange, accessorChange};
            } else {
                changes = new Change[]{propertiesFileChange};
            }
            String name = keys.size() == 1 ? PropertiesFileEditorMessages.PropertiesCorrectionProcessor_remove_property_label : PropertiesFileEditorMessages.PropertiesCorrectionProcessor_remove_properties_label;
            resultingCollections.add(new RemovePropertiesProposal(name, 4, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"), changes));
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return false;
        }
        return true;
    }

    private static boolean getRenameKeysProposals(PropertiesAssistContext invocationContext, ArrayList<ICompletionProposal> resultingCollections) throws BadLocationException, BadPartitioningException {
        ISourceViewer sourceViewer = invocationContext.getSourceViewer();
        IDocument document = invocationContext.getDocument();
        int selectionOffset = invocationContext.getOffset();
        int selectionLength = invocationContext.getLength();
        IField field = null;
        IType accessorClass = invocationContext.getAccessorType();
        if (accessorClass == null || !PropertiesQuickAssistProcessor.isEclipseNLSUsed(accessorClass)) {
            return false;
        }
        List<String> keys = PropertiesQuickAssistProcessor.getKeysFromSelection(document, selectionOffset, selectionLength);
        if (keys == null || keys.size() != 1) {
            return false;
        }
        field = accessorClass.getField(keys.get(0));
        if (!field.exists()) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        String name = PropertiesFileEditorMessages.PropertiesCorrectionProcessor_rename_in_workspace;
        resultingCollections.add(new RenameKeyProposal(name, 5, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"), field, sourceViewer.getTextWidget().getShell()));
        return true;
    }

    private static boolean isEclipseNLSUsed(IType accessor) {
        IType nls;
        block4: {
            IJavaProject javaProject = accessor.getJavaProject();
            if (javaProject == null || !javaProject.exists()) {
                return false;
            }
            try {
                nls = javaProject.findType("org.eclipse.osgi.util.NLS");
                if (nls != null) break block4;
                return false;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        ITypeHierarchy supertypeHierarchy = accessor.newSupertypeHierarchy(null);
        return supertypeHierarchy.contains(nls);
    }

    private static List<String> getKeysFromSelection(IDocument document, int selectionOffset, int selectionLength) throws BadLocationException, BadPartitioningException {
        ArrayList<String> keys = new ArrayList<String>();
        String selection = document.get(selectionOffset, selectionLength == 0 ? 1 : selectionLength).trim();
        if (selection.length() == 0) {
            return null;
        }
        if (selectionLength == 0) {
            ITypedRegion partition = null;
            if (document instanceof IDocumentExtension3) {
                partition = ((IDocumentExtension3)document).getPartition("___pf_partitioning", selectionOffset, false);
            }
            if (partition == null) {
                return null;
            }
            String type = partition.getType();
            if (!type.equals("__dftl_partition_content_type")) {
                return null;
            }
            String key = document.get(partition.getOffset(), partition.getLength()).trim();
            if (key.length() > 0) {
                keys.add(key);
            }
        } else {
            int offset = selectionOffset;
            int endOffset = selectionOffset + selectionLength;
            while (offset < endOffset) {
                String key;
                ITypedRegion partition = null;
                if (document instanceof IDocumentExtension3) {
                    partition = ((IDocumentExtension3)document).getPartition("___pf_partitioning", offset, false);
                }
                if (partition == null) {
                    return null;
                }
                int partitionOffset = partition.getOffset();
                int partitionLength = partition.getLength();
                offset = partitionOffset + partitionLength;
                String type = partition.getType();
                if (!type.equals("__dftl_partition_content_type") || (key = document.get(partitionOffset, partitionLength).trim()).length() <= 0) continue;
                keys.add(key);
            }
        }
        return keys;
    }

    private static class RemovePropertiesProposal
    extends ChangeCorrectionProposal {
        private final Change[] fChanges;

        protected RemovePropertiesProposal(String name, int relevance, Image image, Change[] changes) {
            super(name, null, relevance, image);
            this.fChanges = changes;
        }

        @Override
        protected Change createChange() throws CoreException {
            return new CompositeChange(this.getName(), this.fChanges);
        }

        @Override
        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            StringBuffer buf = new StringBuffer();
            try {
                int i = 0;
                while (i < this.fChanges.length) {
                    if (this.fChanges[i] instanceof TextChange) {
                        TextChange change = (TextChange)this.fChanges[i];
                        String filename = this.getFileName(change);
                        if (filename != null) {
                            buf.append("<b>");
                            buf.append(filename);
                            buf.append("</b>");
                            buf.append("<br>");
                        }
                        change.setKeepPreviewEdits(true);
                        IDocument currentContent = change.getCurrentDocument(monitor);
                        TextEdit rootEdit = change.getEdit();
                        EditAnnotator ea = new EditAnnotator(buf, currentContent){

                            @Override
                            protected boolean rangeRemoved(TextEdit edit) {
                                return this.annotateEdit(edit, "<del>", "</del>");
                            }
                        };
                        rootEdit.accept((TextEditVisitor)ea);
                        ea.unchangedUntil(currentContent.getLength());
                        buf.append("<br><br>");
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
            return buf.toString();
        }

        private String getFileName(TextChange change) {
            Object modifiedElement = change.getModifiedElement();
            if (modifiedElement instanceof IFile) {
                return ((IFile)modifiedElement).getName();
            }
            if (modifiedElement instanceof ICompilationUnit) {
                return ((ICompilationUnit)modifiedElement).getElementName();
            }
            return null;
        }
    }

    private static class RenameKeyProposal
    extends ChangeCorrectionProposal {
        private final IField fField;
        private final Shell fShell;

        public RenameKeyProposal(String name, int relevance, Image image, IField field, Shell shell) {
            super(name, null, relevance, image);
            this.fField = field;
            this.fShell = shell;
        }

        @Override
        public void apply(IDocument document) {
            try {
                RefactoringExecutionStarter.startRenameRefactoring((IJavaElement)this.fField, this.fShell);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }

        @Override
        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            return PropertiesFileEditorMessages.PropertiesCorrectionProcessor_rename_in_workspace_description;
        }

        @Override
        public String getCommandId() {
            return "org.eclipse.jdt.ui.edit.text.java.rename.element";
        }
    }
}

