/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarBuilder;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarManifestProvider;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerUtil;
import org.eclipse.jdt.ui.jarpackager.IManifestProvider;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.swt.widgets.Shell;

public class UnpackJarBuilder
extends FatJarBuilder {
    public static final String BUILDER_ID = "org.eclipse.jdt.ui.unpack_jar_builder";
    private static final String SUBFOLDER_SUFFIX = "_lib";
    private final String fSubfolder;
    private final IPath fSubfolderPath;
    private JarPackageData fJarPackage;
    private Set<String> jarNames;

    public UnpackJarBuilder(JarPackageData jarPackage) {
        this.fSubfolder = String.valueOf(jarPackage.getAbsoluteJarLocation().removeFileExtension().lastSegment()) + SUBFOLDER_SUFFIX;
        this.fSubfolderPath = jarPackage.getAbsoluteJarLocation().removeLastSegments(1).append(this.fSubfolder);
        this.fJarPackage = jarPackage;
    }

    @Override
    public String getId() {
        return BUILDER_ID;
    }

    @Override
    public boolean isMergeManifests() {
        return false;
    }

    @Override
    public boolean isRemoveSigners() {
        return false;
    }

    @Override
    public IManifestProvider getManifestProvider() {
        return new FatJarManifestProvider(this);
    }

    @Override
    public String getManifestClasspath() {
        ArrayList<String> renamedJarNames = new ArrayList<String>();
        Object[] elements = this.fJarPackage.getElements();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)element).isArchive()) {
                String jarName = ((IPackageFragmentRoot)element).getPath().toFile().getName();
                while (renamedJarNames.contains(jarName)) {
                    jarName = FatJarPackagerUtil.nextNumberedFileName(jarName);
                }
                renamedJarNames.add(jarName);
            }
            ++i;
        }
        StringBuffer result = new StringBuffer();
        result.append(".");
        for (String jarName : renamedJarNames) {
            result.append(" ").append(this.fSubfolder).append("/").append(jarName);
        }
        return result.toString();
    }

    @Override
    public void open(JarPackageData jarPackage, Shell displayShell, MultiStatus status) throws CoreException {
        super.open(jarPackage, displayShell, status);
        this.fJarPackage = jarPackage;
        this.jarNames = new HashSet<String>();
        this.createBlankSubfolder(displayShell, jarPackage.allowOverwrite());
    }

    protected void createBlankSubfolder(Shell parent, boolean allowOverwrite) throws CoreException {
        File folder = this.fSubfolderPath.toFile();
        if (!folder.exists()) {
            if (!folder.mkdirs()) {
                throw JarPackagerUtil.createCoreException("Could not create lib-folder '" + folder.getAbsolutePath() + "'", null);
            }
        } else {
            if (!folder.canWrite()) {
                throw JarPackagerUtil.createCoreException("Folder '" + folder.getAbsolutePath() + "' is not writable", null);
            }
            if (!(allowOverwrite || parent != null && JarPackagerUtil.askForOverwriteFolderPermission(parent, this.fSubfolderPath, true))) {
                throw JarPackagerUtil.createCoreException("Folder '" + folder.getAbsolutePath() + "' exists and should not be overwritten", null);
            }
            File[] jarFiles = folder.listFiles();
            int i = 0;
            while (i < jarFiles.length) {
                if (!jarFiles[i].isFile()) {
                    throw JarPackagerUtil.createCoreException("Subfolder '" + jarFiles[i].getAbsolutePath() + "' exists", null);
                }
                if (!jarFiles[i].delete()) {
                    throw JarPackagerUtil.createCoreException("Could not delete file '" + jarFiles[i].getAbsolutePath() + "'", null);
                }
                ++i;
            }
        }
    }

    @Override
    public void writeArchive(ZipFile jarFile, IProgressMonitor progressMonitor) {
        File jarPathFile = new File(jarFile.getName());
        String jarName = jarPathFile.getName();
        while (this.jarNames.contains(jarName)) {
            jarName = FatJarPackagerUtil.nextNumberedFileName(jarName);
        }
        this.jarNames.add(jarName);
        File destJarPathFile = new File(this.fSubfolderPath.toFile(), jarName);
        this.copyFile(jarPathFile, destJarPathFile);
    }

    private void copyFile(File src, File dest) {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = new FileInputStream(src);
                out = new FileOutputStream(dest);
                byte[] buf = new byte[4096];
                int cnt = ((InputStream)in).read(buf);
                while (cnt > 0) {
                    out.write(buf, 0, cnt);
                    cnt = ((InputStream)in).read(buf);
                }
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {}
        try {
            ((InputStream)in).close();
        }
        catch (IOException iOException) {}
    }
}

