/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.models;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.MapChangeListener;
import javafx.scene.Node;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.common.dispose.IDisposable;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class HoverModel
extends IAdaptable.Bound.Impl<IViewer>
implements IDisposable {
    public static final String HOVER_PROPERTY = "hover";
    public static final String HOVER_INTENT_PROPERTY = "hoverIntent";
    private ObjectProperty<IVisualPart<? extends Node>> hoverProperty = new SimpleObjectProperty((Object)this, "hover");
    private ObjectProperty<IContentPart<? extends Node>> hoverIntentProperty = new SimpleObjectProperty((Object)this, "hoverIntent");
    private MapChangeListener<Node, IVisualPart<? extends Node>> visualPartMapListener = new MapChangeListener<Node, IVisualPart<? extends Node>>(){

        public void onChanged(MapChangeListener.Change<? extends Node, ? extends IVisualPart<? extends Node>> change) {
            if (change.wasRemoved()) {
                IVisualPart valueRemoved = (IVisualPart)change.getValueRemoved();
                if (HoverModel.this.hoverProperty.get() == valueRemoved) {
                    HoverModel.this.clearHover();
                }
                if (HoverModel.this.hoverIntentProperty.get() == valueRemoved) {
                    HoverModel.this.clearHoverIntent();
                }
            }
        }
    };

    public void clearHover() {
        this.setHover(null);
    }

    public void clearHoverIntent() {
        this.setHoverIntent(null);
    }

    public void dispose() {
    }

    public IVisualPart<? extends Node> getHover() {
        return (IVisualPart)this.hoverProperty.get();
    }

    public IContentPart<? extends Node> getHoverIntent() {
        return (IContentPart)this.hoverIntentProperty.get();
    }

    public ObjectProperty<IContentPart<? extends Node>> hoverIntentProperty() {
        return this.hoverIntentProperty;
    }

    public ObjectProperty<IVisualPart<? extends Node>> hoverProperty() {
        return this.hoverProperty;
    }

    public void setAdaptable(IViewer adaptable) {
        if (this.getAdaptable() != null) {
            ((IViewer)this.getAdaptable()).visualPartMapProperty().removeListener(this.visualPartMapListener);
        }
        super.setAdaptable((IAdaptable)adaptable);
        if (adaptable != null) {
            adaptable.visualPartMapProperty().addListener(this.visualPartMapListener);
        }
        this.clearHover();
        this.clearHoverIntent();
    }

    public void setHover(IVisualPart<? extends Node> cp) {
        if (cp != this.hoverProperty.get()) {
            this.hoverProperty.set(cp);
        }
    }

    public void setHoverIntent(IContentPart<? extends Node> cp) {
        if (cp != this.hoverIntentProperty.get()) {
            this.hoverIntentProperty.set(cp);
        }
    }
}

