/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCorePlugin;
import org.eclipse.epp.internal.mpc.core.util.Messages;
import org.osgi.util.tracker.ServiceTracker;

public class ProxyHelper {
    private static ServiceTracker proxyServiceTracker;

    public static synchronized void acquireProxyService() {
        if (proxyServiceTracker == null) {
            proxyServiceTracker = new ServiceTracker(MarketplaceClientCorePlugin.getBundle().getBundleContext(), IProxyService.class.getName(), null);
            proxyServiceTracker.open();
        }
    }

    public static void installAuthenticator() {
    }

    public static synchronized void releaseProxyService() {
        if (proxyServiceTracker != null) {
            proxyServiceTracker.close();
        }
    }

    public static void uninstallAuthenticator() {
    }

    public static IProxyData getProxyData(String url) {
        IProxyService proxyService = ProxyHelper.getProxyService();
        if (proxyService != null) {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            return ProxyHelper.doGetProxyData(proxyService, uri);
        }
        return null;
    }

    public static IProxyData getProxyData(URI uri) {
        IProxyService proxyService = ProxyHelper.getProxyService();
        if (proxyService != null) {
            return ProxyHelper.doGetProxyData(proxyService, uri);
        }
        return null;
    }

    private static IProxyData doGetProxyData(IProxyService proxyService, URI uri) {
        IProxyData[] proxyData = proxyService.select(uri);
        if (proxyData != null && proxyData.length > 0 && proxyData[0] != null) {
            IProxyData pd = proxyData[0];
            return pd;
        }
        return null;
    }

    protected static IProxyService getProxyService() {
        return proxyServiceTracker == null ? null : (IProxyService)proxyServiceTracker.getService();
    }

    static Authenticator getDefaultAuthenticator() {
        Field authenticatorField = Authenticator.class.getDeclaredField("theAuthenticator");
        boolean accessible = authenticatorField.isAccessible();
        try {
            if (!accessible) {
                authenticatorField.setAccessible(true);
            }
            Authenticator authenticator = (Authenticator)authenticatorField.get(null);
            if (!accessible) {
                authenticatorField.setAccessible(false);
            }
            return authenticator;
        }
        catch (Throwable throwable) {
            try {
                if (!accessible) {
                    authenticatorField.setAccessible(false);
                }
                throw throwable;
            }
            catch (Exception e) {
                MarketplaceClientCore.getLog().log((IStatus)new Status(2, "org.eclipse.epp.mpc.core", Messages.ProxyHelper_replacingAuthenticator, (Throwable)e));
                return null;
            }
        }
    }
}

