/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.painter.cell.decorator;

import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.CellPainterWrapper;
import net.sourceforge.nattable.painter.cell.ICellPainter;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.ColorUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class LightCornerBorderDecorator
extends CellPainterWrapper {
    private static final int PT_CORN_SIZE = 6;
    private static final int DIM_DECAY = 4;
    private static final int CORN_DIM_RATIO = 3;
    private static final int CORN_DIM_DECAY = 2;
    private static final int IDX0 = 0;
    private static final int IDX1 = 1;
    private static final int IDX2 = 2;
    private static final int IDX3 = 3;
    private static final int IDX4 = 4;
    private static final int IDX5 = 5;

    public LightCornerBorderDecorator(ICellPainter interiorPainter) {
        super(interiorPainter);
    }

    public void paintCell(LayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        Rectangle interiorBounds = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        super.paintCell(cell, gc, interiorBounds, configRegistry);
        Color originalForeground = gc.getForeground();
        Color originalBackground = gc.getBackground();
        gc.setForeground(ColorUtils.getHeaderBorderColor());
        gc.setBackground(ColorUtils.getCornerColor());
        gc.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height);
        gc.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int[] pointArray = new int[]{rectangle.x + rectangle.width / 3 - 2, rectangle.y + rectangle.height - 4, rectangle.x + rectangle.width - 4, rectangle.y + rectangle.height / 3 - 2, rectangle.x + rectangle.width - 4, rectangle.y + rectangle.height - 4};
        gc.fillPolygon(pointArray);
        gc.setForeground(originalForeground);
        gc.setBackground(originalBackground);
    }
}

