/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.util.LinkedList;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.spi.server.StoreAccessorBase;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;

public class StoreAccessorPool {
    public static final int DEFAULT_CAPACITY = 15;
    private IStore store;
    private Object context;
    private int capacity = 15;
    private LinkedList<StoreAccessorBase> accessors = new LinkedList();

    public StoreAccessorPool(IStore store, Object context) {
        this.store = store;
        this.context = context;
    }

    public IStore getStore() {
        return this.store;
    }

    public Object getContext() {
        return this.context;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        this.retainStoreAccessors(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoreAccessor(StoreAccessorBase storeAccessor) {
        try {
            storeAccessor.doPassivate();
            boolean full = false;
            LinkedList<StoreAccessorBase> linkedList = this.accessors;
            synchronized (linkedList) {
                if (this.accessors.size() >= this.capacity) {
                    full = true;
                } else {
                    this.accessors.addFirst(storeAccessor);
                }
            }
            if (full) {
                this.disposeStoreAccessor(storeAccessor);
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreAccessorBase removeStoreAccessor(Object context) {
        StoreAccessorBase accessor;
        LinkedList<StoreAccessorBase> linkedList = this.accessors;
        synchronized (linkedList) {
            accessor = this.accessors.poll();
        }
        if (accessor != null) {
            try {
                accessor.doUnpassivate();
                accessor.setContext(context);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                return null;
            }
        }
        return accessor;
    }

    public void dispose() {
        this.retainStoreAccessors(0);
        this.context = null;
        this.store = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retainStoreAccessors(int targetSize) {
        LinkedList<StoreAccessorBase> linkedList = this.accessors;
        synchronized (linkedList) {
            while (this.accessors.size() > targetSize) {
                StoreAccessorBase accessor = this.accessors.removeLast();
                this.disposeStoreAccessor(accessor);
            }
        }
    }

    protected void disposeStoreAccessor(StoreAccessorBase accessor) {
        LifecycleUtil.deactivate((Object)accessor, (OMLogger.Level)OMLogger.Level.WARN);
    }
}

