/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.lissome.db;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeStore;
import org.eclipse.emf.cdo.server.internal.lissome.db.BranchesTable;
import org.eclipse.emf.cdo.server.internal.lissome.db.CommitInfosTable;
import org.eclipse.emf.cdo.server.internal.lissome.db.IndexReader;
import org.eclipse.emf.cdo.server.internal.lissome.db.IndexWriter;
import org.eclipse.emf.cdo.server.internal.lissome.db.ObjectsTable;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.spi.db.DBAdapter;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.h2.jdbcx.JdbcDataSource;

public class Index
implements IDBConnectionProvider {
    public static final long NULL_POINTER = 0L;
    private static final boolean DEBUG = false;
    private static final String INDENT = "       ";
    private LissomeStore store;
    private IDBSchema schema = DBUtil.createSchema((String)"lissome");
    private IDBAdapter adapter;
    private DataSource dataSource;
    private IndexWriter writer;
    protected CommitInfosTable commitInfos;
    protected ObjectsTable objects;
    protected BranchesTable branches;

    public Index(LissomeStore store) {
        this.store = store;
        this.adapter = this.createAdapter();
        this.dataSource = this.createDataSource();
        this.writer = this.createWriter();
        this.commitInfos = new CommitInfosTable(this);
        this.objects = new ObjectsTable(this);
        if (this.isSupportingBranches()) {
            this.branches = new BranchesTable(this);
        }
        ((InternalDBSchema)this.schema).lock();
    }

    public LissomeStore getStore() {
        return this.store;
    }

    public InternalRepository getRepository() {
        return this.store.getRepository();
    }

    public CDOCommonRepository.IDGenerationLocation getIDGenerationLocation() {
        return this.getRepository().getIDGenerationLocation();
    }

    public boolean isSupportingAudits() {
        return this.getRepository().isSupportingAudits();
    }

    public boolean isSupportingBranches() {
        return this.getRepository().isSupportingBranches();
    }

    public IndexWriter getWriter() {
        return this.writer;
    }

    public CDOID getCDOID(ResultSet resultSet, int column) throws SQLException {
        if (this.getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.CLIENT) {
            byte[] value = resultSet.getBytes(column);
            return CDOIDUtil.createUUID((byte[])value);
        }
        long value = resultSet.getLong(column);
        return CDOIDUtil.createLong((long)value);
    }

    public void setCDOID(PreparedStatement statement, int column, CDOID id) throws SQLException {
        if (this.getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.CLIENT) {
            byte[] value = CDOIDUtil.getByteArray((CDOID)id);
            statement.setBytes(column, value);
        } else {
            long value = CDOIDUtil.getLong((CDOID)id);
            statement.setLong(column, value);
        }
    }

    protected IDBAdapter createAdapter() {
        return new H2Adapter();
    }

    protected DataSource createDataSource() {
        String repoName = this.getRepository().getName();
        return Index.createDataSource(this.store.getFolder(), repoName, repoName);
    }

    protected IndexWriter createWriter() {
        return new IndexWriter(this);
    }

    public IndexReader createReader() {
        return new IndexReader(this);
    }

    public void createTables() {
        Connection connection = this.writer.getConnection();
        this.schema.create(this.adapter, connection);
    }

    public IDBSchema getSchema() {
        return this.schema;
    }

    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    public void trace(ContextTracer tracer, PreparedStatement stmt) {
        if (tracer.isEnabled()) {
            tracer.trace(this.format(stmt));
        }
    }

    private String format(PreparedStatement stmt) {
        if (this.adapter instanceof DBAdapter) {
            return ((DBAdapter)this.adapter).format(stmt);
        }
        return stmt.toString();
    }

    public void trace(ContextTracer tracer, ResultSet resultSet) {
        if (tracer.isEnabled()) {
            tracer.trace(this.format(resultSet));
        }
    }

    private String format(ResultSet resultSet) {
        if (this.adapter instanceof DBAdapter) {
            return INDENT + ((DBAdapter)this.adapter).format(resultSet);
        }
        return INDENT + resultSet;
    }

    public static DataSource createDataSource(File folder, String dbName, String schemaName) {
        File database = new File(new File(folder, "db"), dbName);
        String schema = schemaName != null ? ";SCHEMA=" + schemaName : "";
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:" + database.getAbsolutePath() + schema);
        return dataSource;
    }
}

