/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.dialogs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.core.ui.dialogs.AbstractFilteredItemsSelectionDialog;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.egf.model.fcore.provider.FcoreItemProviderAdapterFactory;
import org.eclipse.egf.model.fcore.provider.FcoreResourceItemProviderAdapterFactory;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.provider.PatternCustomItemProviderAdapterFactory;
import org.eclipse.egf.model.pattern.provider.PatternItemProviderAdapterFactory;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternSelectionDialog
extends AbstractFilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.egf.pattern.ui.editors.dialogs.PatternSelectionDialog";
    private Pattern _pattern;
    private EditingDomain _editingDomain;
    private IPlatformFcore[] _fcores = EGFCorePlugin.getPlatformFcores();
    protected ComposedAdapterFactory _adapterFactory;
    protected ComposedAdapterFactory _selectionAdapterFactory;

    protected ILabelProvider getLabelProvider() {
        return new PatternLabelProvider((AdapterFactory)this._adapterFactory);
    }

    protected ILabelDecorator getSelectionLabelProvider() {
        return new PatternSelectionLabelProvider((AdapterFactory)this._selectionAdapterFactory);
    }

    protected ILabelProvider getDetailsLabelProvider() {
        return new PatternDetailsLabelProvider((AdapterFactory)this._adapterFactory);
    }

    public PatternSelectionDialog(Shell parentShell, boolean multipleSelection) {
        this(parentShell, null, multipleSelection);
    }

    public PatternSelectionDialog(Shell parentShell, Pattern pattern, boolean multipleSelection) {
        super(parentShell, multipleSelection);
        this._editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
        if (pattern != null) {
            this._pattern = (Pattern)this._editingDomain.getResourceSet().getEObject(EcoreUtil.getURI((EObject)pattern), true);
        }
        this._adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this._adapterFactory.addAdapterFactory((AdapterFactory)new FcoreResourceItemProviderAdapterFactory());
        this._adapterFactory.addAdapterFactory((AdapterFactory)new PatternItemProviderAdapterFactory());
        this._adapterFactory.addAdapterFactory((AdapterFactory)new FcoreItemProviderAdapterFactory());
        this._adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this._selectionAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this._selectionAdapterFactory.addAdapterFactory((AdapterFactory)new FcoreResourceItemProviderAdapterFactory());
        this._selectionAdapterFactory.addAdapterFactory((AdapterFactory)new PatternCustomItemProviderAdapterFactory());
        this._selectionAdapterFactory.addAdapterFactory((AdapterFactory)new FcoreItemProviderAdapterFactory());
        this._selectionAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.setTitle(NLS.bind((String)CoreUIMessages._UI_GenericSelectionDialog_dialogTitle, (Object)Pattern.class.getSimpleName()));
        this.setMessage(NLS.bind((String)CoreUIMessages._UI_GenericSelectionDialog_dialogMessage, (Object)Pattern.class.getSimpleName()));
        this.setListLabelProvider(this.getLabelProvider());
        this.setListSelectionLabelDecorator(this.getSelectionLabelProvider());
        this.setDetailsLabelProvider(this.getDetailsLabelProvider());
        this.setSelectionHistory(new PatternSelectionHistory());
        if (this._pattern != null && this._pattern.eResource() != null && this._pattern.eResource() instanceof IPlatformFcoreProvider) {
            IPlatformFcore fcore = ((IPlatformFcoreProvider)this._pattern.eResource()).getIPlatformFcore();
            if (fcore != null) {
                this.setSeparatorLabel(NLS.bind((String)CoreUIMessages._UI_FilteredItemsSelectionDialog_separatorLabel, (Object)fcore.getPlatformBundle().getBundleId()));
            } else {
                this.setSeparatorLabel(CoreUIMessages._UI_FilteredItemsSelectionDialog_platformSeparatorLabel);
            }
        } else {
            this.setSeparatorLabel(CoreUIMessages._UI_FilteredItemsSelectionDialog_platformSeparatorLabel);
        }
    }

    protected void handleSelected(StructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        super.handleSelected(selection);
        if (selection.size() != 0) {
            UniqueEList patterns = new UniqueEList();
            for (Object object : selection.toList()) {
                if (!(object instanceof Pattern)) continue;
                patterns.add((Pattern)object);
            }
            this.notifySelectionListeners(patterns.toArray());
        }
    }

    public Shell getShell() {
        return super.getShell() != null ? super.getShell() : this.getParentShell();
    }

    public Control createPage(Composite parent) {
        this.dialogArea = this.createDialogArea(parent);
        return this.dialogArea;
    }

    public Object[] getResult() {
        Object[] result = super.getResult();
        if (result == null) {
            this.computeResult();
        }
        if ((result = super.getResult()) == null || result.length == 0) {
            return null;
        }
        ArrayList<Pattern> resultToReturn = new ArrayList<Pattern>();
        int i = 0;
        while (i < result.length) {
            if (result[i] instanceof Pattern) {
                resultToReturn.add((Pattern)result[i]);
            }
            ++i;
        }
        return resultToReturn.toArray();
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new PatternSearchItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        try {
            for (Pattern pattern : PatternHelper.TRANSACTIONNAL_COLLECTOR.getAllPatterns()) {
                if (this._pattern != null && EcoreUtil.getURI((EObject)this._pattern).equals(EcoreUtil.getURI((EObject)pattern))) continue;
                try {
                    contentProvider.add((Object)pattern, itemsFilter);
                }
                catch (OperationCanceledException e) {
                    return;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        catch (OperationCanceledException e) {
            return;
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof IPlatformFcore) {
            IPlatformFcore fc = (IPlatformFcore)item;
            return fc.getURI().toString();
        }
        return null;
    }

    protected Comparator<Pattern> getItemsComparator() {
        return new PatternSearchComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, Activator.getDefault().getBundle().getSymbolicName(), 0, "", null);
    }

    private class PatternDetailsLabelProvider
    extends LabelProvider {
        ILabelProvider _adapterFactoryLabelProvider;

        public PatternDetailsLabelProvider(AdapterFactory adapterFactory) {
            this._adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(adapterFactory);
        }

        public Image getImage(Object element) {
            if (!(element instanceof Pattern)) {
                return this._adapterFactoryLabelProvider.getImage(element);
            }
            Pattern pattern = (Pattern)element;
            if (pattern.eResource() == null) {
                return this._adapterFactoryLabelProvider.getImage((Object)pattern);
            }
            return this._adapterFactoryLabelProvider.getImage((Object)pattern.eResource());
        }

        public String getText(Object element) {
            if (!(element instanceof Pattern)) {
                return this._adapterFactoryLabelProvider.getText(element);
            }
            Pattern pattern = (Pattern)element;
            if (pattern.eResource() == null || !(pattern.eResource() instanceof IPlatformFcoreProvider)) {
                return this._adapterFactoryLabelProvider.getText((Object)pattern);
            }
            IPlatformFcore fcore = ((IPlatformFcoreProvider)pattern.eResource()).getIPlatformFcore();
            if (fcore == null) {
                return this._adapterFactoryLabelProvider.getText((Object)pattern);
            }
            StringBuffer buffer = new StringBuffer(fcore.getURI() == null ? "" : URI.decode((String)fcore.getURI().toString()));
            if (fcore.isTarget()) {
                buffer.append(" [Target]");
            } else if (fcore.isRuntime()) {
                buffer.append(" [Runtime]");
            } else {
                buffer.append(" [Workspace]");
            }
            buffer.append(" [");
            buffer.append(fcore.getPlatformBundle().getInstallLocation());
            buffer.append("]");
            return buffer.toString();
        }
    }

    private class PatternLabelProvider
    extends AdapterFactoryLabelProvider
    implements ILabelDecorator {
        public PatternLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getText(Object element) {
            if (!(element instanceof Pattern)) {
                return super.getText(element);
            }
            return ((Pattern)element).getName();
        }

        public String decorateText(String text, Object element) {
            return this.getText(element);
        }

        public Image decorateImage(Image image, Object element) {
            return this.getImage(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PatternSearchComparator
    implements Comparator<Pattern>,
    Serializable {
        public static final long serialVersionUID = 1L;

        private PatternSearchComparator() {
        }

        @Override
        public int compare(Pattern p1, Pattern p2) {
            if (p1.getName() == null && p2.getName() == null) {
                return 0;
            }
            if (p1.getName() != null && p2.getName() == null) {
                return -1;
            }
            if (p1.getName() == null && p2.getName() != null) {
                return 1;
            }
            return p1.getName().compareTo(p2.getName());
        }
    }

    private class PatternSearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private PatternSearchItemsFilter() {
            super((FilteredItemsSelectionDialog)PatternSelectionDialog.this);
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof Pattern)) {
                return false;
            }
            Pattern pattern = (Pattern)item;
            if (pattern.getName() == null) {
                return true;
            }
            return this.matches(pattern.getName());
        }

        public boolean isConsistentItem(Object item) {
            return item instanceof Pattern;
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.isSubFilter(filter)) {
                return false;
            }
            return filter instanceof PatternSearchItemsFilter;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.equalsFilter(filter)) {
                return false;
            }
            return filter instanceof PatternSearchItemsFilter;
        }
    }

    private class PatternSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private static final String TAG_URI = "path";

        protected Object restoreItemFromMemento(IMemento memento) {
            block9: {
                String tag = memento.getString(TAG_URI);
                if (tag == null) {
                    return null;
                }
                try {
                    IPlatformFcore fcore;
                    PatternSelectionDialog.this._pattern = (Pattern)PatternSelectionDialog.this._editingDomain.getResourceSet().getEObject(URI.createURI((String)tag), true);
                    if (!(PatternSelectionDialog.this._pattern.eResource() instanceof IPlatformFcoreProvider) || (fcore = ((IPlatformFcoreProvider)PatternSelectionDialog.this._pattern.eResource()).getIPlatformFcore()) == null) break block9;
                    IPlatformFcore[] iPlatformFcoreArray = PatternSelectionDialog.this._fcores;
                    int n = iPlatformFcoreArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPlatformFcore innerFcore = iPlatformFcoreArray[n2];
                        if (innerFcore.equals(fcore)) {
                            Pattern pattern = PatternSelectionDialog.this._pattern;
                            return pattern;
                        }
                        try {
                            ++n2;
                            continue;
                        }
                        catch (Exception exception) {}
                        break;
                    }
                }
                finally {
                    PatternSelectionDialog.this._pattern = null;
                }
            }
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
            if (PatternSelectionDialog.this.getReturnCode() == 0) {
                Object[] items = this.getHistoryItems();
                int i = 0;
                while (i < items.length) {
                    element.putString(TAG_URI, EcoreUtil.getURI((EObject)((Pattern)items[i])).toString());
                    ++i;
                }
            } else if (PatternSelectionDialog.this._pattern != null) {
                element.putString(TAG_URI, EcoreUtil.getURI((EObject)PatternSelectionDialog.this._pattern).toString());
            }
        }
    }

    private class PatternSelectionLabelProvider
    extends AdapterFactoryLabelProvider
    implements ILabelDecorator {
        public PatternSelectionLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String decorateText(String text, Object element) {
            return this.getText(element);
        }

        public Image decorateImage(Image image, Object element) {
            return this.getImage(element);
        }
    }
}

