/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.activestatedebugger.InstrumentationSetup;
import org.eclipse.dltk.tcl.activestatedebugger.InstrumentationUtils;
import org.eclipse.dltk.tcl.activestatedebugger.TclActiveStateDebuggerPlugin;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.ContainerPattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.ContainerType;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationConfig;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationContentProvider;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationMode;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.LibraryContainerElement;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.ModelElementPattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PackagePattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.Pattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SourcePattern;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclPackageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationConfigProcessor
extends InstrumentationSetup {
    private final IInterpreterInstall install;
    private final IScriptProject project;

    public InstrumentationConfigProcessor(IProject project) {
        super(EnvironmentManager.getEnvironment((IProject)project));
        IInterpreterInstall ii;
        this.project = DLTKCore.create((IProject)project);
        try {
            ii = ScriptRuntime.getInterpreterInstall((IScriptProject)this.project);
        }
        catch (CoreException e) {
            TclActiveStateDebuggerPlugin.warn(e);
            ii = null;
        }
        this.install = ii;
    }

    public InstrumentationConfigProcessor(IScriptProject project, IInterpreterInstall install) {
        super(EnvironmentManager.getEnvironment((IModelElement)project));
        this.project = project;
        this.install = install;
    }

    public void configure(InstrumentationConfig config) {
        if (this.environment == null) {
            return;
        }
        InstrumentationMode mode = InstrumentationUtils.getMode(config);
        if (mode == InstrumentationMode.DEFAULT) {
            return;
        }
        InstrumentationContentProvider provider = new InstrumentationContentProvider();
        HashSet<IModelElement> processed = new HashSet<IModelElement>();
        HashSet<IScriptProject> projects = new HashSet<IScriptProject>();
        InstrumentationUtils.collectProjects(projects, this.project);
        HashMap<ContainerType, Boolean> containerIncludes = new HashMap<ContainerType, Boolean>();
        if (mode == InstrumentationMode.SOURCES) {
            for (IScriptProject project : projects) {
                InstrumentationConfigProcessor.collect(provider, processed, (IModelElement)project);
                this.addProject(project, true);
            }
        } else {
            for (Pattern pattern : config.getModelElements()) {
                if (pattern instanceof ModelElementPattern) {
                    IModelElement element = DLTKCore.create((String)((ModelElementPattern)pattern).getHandleIdentifier());
                    if (element == null) continue;
                    InstrumentationConfigProcessor.collect(provider, processed, element);
                    if (element instanceof ISourceModule) {
                        this.addSourceModule((ISourceModule)element, pattern.isInclude());
                        continue;
                    }
                    if (element instanceof IScriptFolder) {
                        this.addScriptFolder((IScriptFolder)element, pattern.isInclude());
                        continue;
                    }
                    if (element instanceof IProjectFragment) {
                        IProjectFragment fragment = (IProjectFragment)element;
                        this.addProjectFragment(fragment, pattern.isInclude());
                        continue;
                    }
                    if (!(element instanceof IScriptProject)) continue;
                    this.addProject((IScriptProject)element, pattern.isInclude());
                    continue;
                }
                if (pattern instanceof PackagePattern) {
                    PackagePattern pp;
                    TclPackageInfo info;
                    if (this.install == null || (info = TclPackagesManager.getPackageInfo((IInterpreterInstall)this.install, (String)(pp = (PackagePattern)pattern).getPackageName(), (boolean)true)) == null) continue;
                    for (String source : info.getSources()) {
                        this.addFileHandle(this.environment.getFile((IPath)new Path(source)), false, pattern.isInclude());
                    }
                    continue;
                }
                if (pattern instanceof SourcePattern) {
                    SourcePattern sp = (SourcePattern)pattern;
                    this.addFileHandle(this.environment.getFile((IPath)new Path(sp.getSourcePath())), false, pattern.isInclude());
                    continue;
                }
                if (!(pattern instanceof ContainerPattern)) continue;
                ContainerPattern c = (ContainerPattern)pattern;
                containerIncludes.put(c.getType(), pattern.isInclude());
            }
            for (IScriptProject project : projects) {
                if (!processed.add((IModelElement)project)) continue;
                this.addProject(project, false);
            }
        }
        for (IProjectFragment fragment : LibraryContainerElement.collectExternalFragments(projects)) {
            if (!processed.add((IModelElement)fragment)) continue;
            this.addProjectFragment(fragment, this.isIncluded(containerIncludes, ContainerType.LIBRARIES));
        }
    }

    private boolean isIncluded(Map<ContainerType, Boolean> containerIncludes, ContainerType containerType) {
        Boolean value = containerIncludes.get((Object)containerType);
        return value != null && value != false;
    }

    private static void collect(InstrumentationContentProvider provider, Set<IModelElement> processed, IModelElement element) {
        Object parent;
        if (processed.add(element) && (parent = provider.getParent(element)) != null && parent instanceof IModelElement) {
            InstrumentationConfigProcessor.collect(provider, processed, (IModelElement)parent);
        }
    }
}

