/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public class Addr2line {
    private String[] args;
    private Process addr2line;
    private BufferedReader stdout;
    private BufferedWriter stdin;
    private String lastaddr;
    private String lastsymbol;
    private String lastline;
    private static final Pattern OUTPUT_PATTERN = Pattern.compile("(.*)( \\(discriminator.*\\))");

    public Addr2line(String command, String[] params, String file) throws IOException {
        this.init(command, params, file);
    }

    public Addr2line(String command, String file) throws IOException {
        this(command, new String[0], file);
    }

    public Addr2line(String file) throws IOException {
        this("addr2line", file);
    }

    protected void init(String command, String[] params, String file) throws IOException {
        if (params == null || params.length == 0) {
            this.args = new String[]{command, "-C", "-f", "-e", file};
        } else {
            this.args = new String[params.length + 1];
            this.args[0] = command;
            System.arraycopy(params, 0, this.args, 1, params.length);
        }
        this.addr2line = ProcessFactory.getFactory().exec(this.args);
        this.stdin = new BufferedWriter(new OutputStreamWriter(this.addr2line.getOutputStream()));
        this.stdout = new BufferedReader(new InputStreamReader(this.addr2line.getInputStream()));
    }

    protected void getOutput(String address) throws IOException {
        if (!address.equals(this.lastaddr)) {
            this.stdin.write(String.valueOf(address) + "\n");
            this.stdin.flush();
            this.lastsymbol = this.stdout.readLine();
            this.lastline = this.stdout.readLine();
            this.lastaddr = address;
        }
    }

    public String getLine(IAddress address) throws IOException {
        this.getOutput(address.toString(16));
        return this.lastline;
    }

    public String getFunction(IAddress address) throws IOException {
        this.getOutput(address.toString(16));
        return this.lastsymbol;
    }

    public String getFileName(IAddress address) throws IOException {
        int index1;
        String filename = null;
        String line = this.getLine(address);
        if (line != null && (index1 = line.lastIndexOf(58)) != -1) {
            int index2 = line.indexOf(58);
            index2 = index1 == index2 ? 0 : --index2;
            filename = line.substring(index2, index1);
        }
        return filename;
    }

    public int getLineNumber(IAddress address) throws IOException {
        int i = 0;
        while (i <= 20) {
            int colon;
            String number;
            String line = this.getLine(address);
            if ((line = this.parserOutput(line)) != null && !(number = line.substring((colon = line.lastIndexOf(58)) + 1)).startsWith("0")) {
                try {
                    return Integer.parseInt(number);
                }
                catch (Exception ex) {
                    return -1;
                }
            }
            address = address.add(i += 4);
        }
        return -1;
    }

    public void dispose() {
        try {
            this.stdout.close();
            this.stdin.close();
            this.addr2line.getErrorStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.addr2line.destroy();
    }

    private String parserOutput(String line) {
        Matcher matcher = OUTPUT_PATTERN.matcher(line);
        if (matcher.matches() && matcher.groupCount() > 1) {
            line = matcher.group(1);
        }
        return line;
    }
}

