/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.projectimport;

import com.gradleware.tooling.toolingutils.binding.Property;
import com.gradleware.tooling.toolingutils.binding.Validator;
import com.gradleware.tooling.toolingutils.binding.Validators;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.BuildConfiguration;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;

public final class ProjectImportConfiguration {
    private final Property<File> projectDir;
    private final Property<Boolean> overwriteWorkspaceSettings;
    private final Property<GradleDistributionWrapper> gradleDistribution;
    private final Property<File> gradleUserHome;
    private final Property<Boolean> applyWorkingSets;
    private final Property<List<String>> workingSets;
    private final Property<Boolean> buildScansEnabled;
    private final Property<Boolean> offlineMode;

    public ProjectImportConfiguration() {
        this((Validator<File>)Validators.noOp(), (Validator<GradleDistributionWrapper>)Validators.noOp(), (Validator<File>)Validators.noOp(), (Validator<Boolean>)Validators.noOp(), (Validator<List<String>>)Validators.noOp());
    }

    public ProjectImportConfiguration(Validator<File> projectDirValidator, Validator<GradleDistributionWrapper> gradleDistributionValidator, Validator<File> gradleUserHomeValidator, Validator<Boolean> applyWorkingSetsValidator, Validator<List<String>> workingSetsValidators) {
        this.projectDir = Property.create(projectDirValidator);
        this.overwriteWorkspaceSettings = Property.create((Validator)Validators.noOp());
        this.gradleDistribution = Property.create(gradleDistributionValidator);
        this.gradleUserHome = Property.create(gradleUserHomeValidator);
        this.applyWorkingSets = Property.create(applyWorkingSetsValidator);
        this.workingSets = Property.create(workingSetsValidators);
        this.buildScansEnabled = Property.create((Validator)Validators.noOp());
        this.offlineMode = Property.create((Validator)Validators.noOp());
    }

    public Property<File> getProjectDir() {
        return this.projectDir;
    }

    public void setProjectDir(File projectDir) {
        this.projectDir.setValue((Object)projectDir);
    }

    public Property<Boolean> getOverwriteWorkspaceSettings() {
        return this.overwriteWorkspaceSettings;
    }

    public void setOverwriteWorkspaceSettings(boolean overwriteWorkspaceSettings) {
        this.overwriteWorkspaceSettings.setValue((Object)overwriteWorkspaceSettings);
    }

    public Property<GradleDistributionWrapper> getGradleDistribution() {
        return this.gradleDistribution;
    }

    public void setGradleDistribution(GradleDistributionWrapper gradleDistribution) {
        this.gradleDistribution.setValue((Object)gradleDistribution);
    }

    public Property<File> getGradleUserHome() {
        return this.gradleUserHome;
    }

    public void setGradleUserHome(File gradleUserHome) {
        this.gradleUserHome.setValue((Object)gradleUserHome);
    }

    public Property<Boolean> getApplyWorkingSets() {
        return this.applyWorkingSets;
    }

    public void setApplyWorkingSets(Boolean applyWorkingSets) {
        this.applyWorkingSets.setValue((Object)applyWorkingSets);
    }

    public Property<List<String>> getWorkingSets() {
        return this.workingSets;
    }

    public void setWorkingSets(List<String> workingSets) {
        this.workingSets.setValue(workingSets);
    }

    public Property<Boolean> getBuildScansEnabled() {
        return this.buildScansEnabled;
    }

    public void setBuildScansEnabled(boolean buildScansEnabled) {
        this.buildScansEnabled.setValue((Object)buildScansEnabled);
    }

    public Property<Boolean> getOfflineMode() {
        return this.offlineMode;
    }

    public void setOfflineMode(boolean offlineMode) {
        this.offlineMode.setValue((Object)offlineMode);
    }

    public BuildConfiguration toBuildConfig() {
        return CorePlugin.configurationManager().createBuildConfiguration((File)this.getProjectDir().getValue(), (Boolean)this.getOverwriteWorkspaceSettings().getValue(), ((GradleDistributionWrapper)this.getGradleDistribution().getValue()).toGradleDistribution(), (File)this.getGradleUserHome().getValue(), (Boolean)this.getBuildScansEnabled().getValue(), (Boolean)this.getOfflineMode().getValue());
    }
}

