/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.bpmn2.modeler.core.validation.ValidationStatusAdapter;
import org.eclipse.bpmn2.modeler.core.validation.ValidationStatusAdapterFactory;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintFactory;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.graphiti.ui.editor.DiagramEditor;

public class BPMN2ValidationStatusLoader {
    DiagramEditor editor;

    public BPMN2ValidationStatusLoader(DiagramEditor editor) {
        this.editor = editor;
    }

    public Set<EObject> load(List<IMarker> markers) {
        if (markers == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<EObject> touched = new LinkedHashSet<EObject>();
        for (IMarker marker : markers) {
            for (EObject markedObject : this.getAllObjects(marker)) {
                IStatus status;
                if (markedObject == null) continue;
                ValidationStatusAdapter statusAdapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)markedObject, ValidationStatusAdapter.class);
                if (statusAdapter == null) {
                    ResourceSet resourceSet = this.editor.getEditingDomain().getResourceSet();
                    resourceSet.getAdapterFactories().add((Object)new ValidationStatusAdapterFactory());
                    statusAdapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)markedObject, ValidationStatusAdapter.class);
                }
                if ((status = this.convertMarker(marker, markedObject)) instanceof ConstraintStatus) {
                    ConstraintStatus cs = (ConstraintStatus)status;
                    for (EObject result : cs.getResultLocus()) {
                        EPackage pkg;
                        if (result == markedObject || (pkg = result.eClass().getEPackage()) == EcorePackage.eINSTANCE) continue;
                        ValidationStatusAdapter sa = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)result, ValidationStatusAdapter.class);
                        sa.addValidationStatus(status);
                        touched.add(result);
                    }
                }
                statusAdapter.addValidationStatus(status);
                touched.add(markedObject);
            }
        }
        return touched;
    }

    private List<EObject> getAllObjects(IMarker marker) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.add(this.getTargetObject(marker));
        result.addAll(this.getRelatedObjects(marker));
        return result;
    }

    private List<EObject> getRelatedObjects(IMarker marker) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        String targetUri = marker.getAttribute("uri", null);
        String uriString = marker.getAttribute("relatedURIs", null);
        if (uriString != null) {
            String[] uris;
            String[] stringArray = uris = uriString.split(" ");
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!s.equals(targetUri)) {
                    URI uri = URI.createURI((String)s);
                    EObject o = this.editor.getEditingDomain().getResourceSet().getEObject(uri, false);
                    if (!(o instanceof EStructuralFeature)) {
                        result.add(o);
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private EObject getTargetObject(IMarker marker) {
        URI uri;
        String uriString = marker.getAttribute("uri", null);
        URI uRI = uri = uriString == null ? null : URI.createURI((String)uriString);
        if (uri == null) {
            return null;
        }
        return this.editor.getEditingDomain().getResourceSet().getEObject(uri, false);
    }

    private IStatus convertMarker(IMarker marker, EObject target) {
        IModelConstraint imc;
        String message = marker.getAttribute("message", "");
        String constraintId = marker.getAttribute("rule", null);
        IConstraintDescriptor icd = constraintId == null ? null : ConstraintRegistry.getInstance().getDescriptor(constraintId);
        IModelConstraint iModelConstraint = imc = icd == null ? null : ConstraintFactory.getInstance().newConstraint(icd);
        if (imc == null) {
            int severity;
            switch (marker.getAttribute("severity", -1)) {
                case 0: {
                    severity = 1;
                    break;
                }
                case 1: {
                    severity = 2;
                    break;
                }
                case 2: {
                    severity = 4;
                    break;
                }
                default: {
                    severity = 0;
                }
            }
            return new Status(severity, "org.eclipse.bpmn2.modeler.core", message);
        }
        List locus = new EditUIMarkerHelper().getTargetObjects((Object)this.editor.getEditingDomain(), marker);
        Iterator it = locus.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof EObject) continue;
            it.remove();
        }
        return new ConstraintStatus(imc, target, message, (Set)(locus == null ? null : new LinkedHashSet(locus)));
    }
}

