/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.activity;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractLayoutBpmn2ShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.event.AbstractBoundaryEventOperation;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class LayoutActivityFeature
extends AbstractLayoutBpmn2ShapeFeature {
    public LayoutActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canLayout(ILayoutContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (!(pe instanceof ContainerShape)) {
            return false;
        }
        BaseElement bo = BusinessObjectUtil.getFirstElementOfType(pe, BaseElement.class);
        return bo != null && bo instanceof Activity;
    }

    public boolean layout(ILayoutContext context) {
        PictogramElement pe;
        IGaService gaService = Graphiti.getGaService();
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm parentGa = containerShape.getGraphicsAlgorithm();
        int newWidth = parentGa.getWidth();
        int newHeight = parentGa.getHeight();
        Shape rectShape = (Shape)containerShape.getChildren().get(0);
        gaService.setSize(rectShape.getGraphicsAlgorithm(), newWidth, newHeight);
        this.layoutInRectangle((RoundedRectangle)rectShape.getGraphicsAlgorithm());
        ShapeDecoratorUtil.setActivityMarkerOffest(containerShape, this.getMarkerContainerOffset());
        ShapeDecoratorUtil.layoutActivityMarker(containerShape);
        Activity activity = BusinessObjectUtil.getFirstElementOfType((PictogramElement)containerShape, Activity.class);
        new AbstractBoundaryEventOperation(){

            @Override
            protected void doWorkInternal(ContainerShape container) {
                LayoutActivityFeature.this.layoutPictogramElement((PictogramElement)container);
            }
        }.doWork(activity, this.getDiagram());
        DIUtils.updateDIShape((PictogramElement)containerShape);
        if (containerShape.eContainer() instanceof ContainerShape && BusinessObjectUtil.containsElementOfType(pe = (PictogramElement)containerShape.eContainer(), SubProcess.class)) {
            this.layoutPictogramElement(pe);
        }
        return true;
    }

    protected int getMarkerContainerOffset() {
        return 0;
    }

    protected void layoutInRectangle(RoundedRectangle rect) {
    }
}

