/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.impl.AbstractDirectEditingFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.platform.ICellEditorProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractBpmn2DirectEditingFeature
extends AbstractDirectEditingFeature
implements ICellEditorProvider {
    public AbstractBpmn2DirectEditingFeature(IFeatureProvider fp) {
        super(fp);
    }

    public int getEditingType() {
        return 9;
    }

    public String getInitialValue(IDirectEditingContext context) {
        String value = "";
        BaseElement be = this.getBusinessObject(context);
        EStructuralFeature feature = be.eClass().getEStructuralFeature("name");
        if (feature != null) {
            value = (String)be.eGet(feature);
        }
        return value == null ? "" : value;
    }

    public void setValue(String value, IDirectEditingContext context) {
        BaseElement be = this.getBusinessObject(context);
        EStructuralFeature feature = be.eClass().getEStructuralFeature("name");
        if (feature != null) {
            be.eSet(feature, (Object)value);
            PictogramElement pe = context.getPictogramElement();
            FeatureSupport.updateLabel(this.getFeatureProvider(), (PictogramElement)((Shape)pe).getContainer(), null);
        }
    }

    public boolean canDirectEdit(IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        return bo instanceof BaseElement && ((BaseElement)bo).eClass().getEStructuralFeature("name") != null;
    }

    private BaseElement getBusinessObject(IDirectEditingContext context) {
        return (BaseElement)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
    }

    public CellEditor createCellEditor(Composite parent) {
        TextCellEditor ce = new TextCellEditor(parent, 16450);
        return ce;
    }

    public void relocate(CellEditor cellEditor, IFigure figure) {
        Text text = (Text)cellEditor.getControl();
        org.eclipse.draw2d.geometry.Rectangle rect = figure.getClientArea().getCopy();
        figure.translateToAbsolute((Translatable)rect);
        Rectangle trim = text.computeTrim(0, 0, 0, 0);
        rect.translate(trim.x, trim.y);
        rect.width += trim.width;
        if (rect.width < 100) {
            rect.x -= (100 - rect.width) / 2;
            rect.width = 100;
        }
        rect.height += trim.height;
        text.setBounds(rect.x, rect.y, rect.width, rect.height);
    }
}

