/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.Templates;
import org.eclipse.bpel.ui.wizards.Messages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewBpelFileTemplatePage
extends WizardPage {
    public static final String PAGE_NAME = "wsdl-creation-page";
    private static final String SOAP_BINDING = "SOAP";
    private static final String HTTP_BINDING = "HTTP";
    private static final String SOAP_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final String HTTP_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/http/";
    private String processTemplateName;
    private String serviceName;
    private String address;
    private String binding;
    private String portName;
    private Text serviceNameText;
    private Text portNameText;
    private Text addressText;
    private final Map<String, String> processTemplateProperties = new HashMap<String, String>();

    public NewBpelFileTemplatePage() {
        super(PAGE_NAME);
        this.setTitle(Messages.NewFileWizard_WSDLCustomPage_Title);
        this.setDescription(Messages.NewFileWizard_WSDLCustomPage_Description);
        this.setImageDescriptor(BPELUIPlugin.INSTANCE.getImageDescriptor("wizban/new_bpel.gif"));
        this.binding = SOAP_BINDING;
        String[] tplNames = BPELUIPlugin.INSTANCE.getTemplates().getTemplateNames();
        if (tplNames != null && tplNames.length > 0) {
            this.processTemplateName = tplNames[0];
        }
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage = this.getWizard().getPage("location-page");
        nextPage.setPreviousPage((IWizardPage)this);
        return nextPage;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)container);
        Label l = new Label(container, 0);
        l.setText(Messages.NewFileWizardPage1_7);
        l.setToolTipText("The template to use for the creation of the new process");
        final Combo processTemplateCombo = new Combo(container, 76);
        processTemplateCombo.setLayoutData((Object)new GridData(768));
        processTemplateCombo.setItems(BPELUIPlugin.INSTANCE.getTemplates().getTemplateNames());
        final Text descriptionText = new Text(container, 2122);
        descriptionText.setBackground(this.getShell().getDisplay().getSystemColor(1));
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 100;
        layoutData.widthHint = 500;
        layoutData.horizontalSpan = 2;
        descriptionText.setLayoutData((Object)layoutData);
        final Group propertiesGroup = new Group(container, 64);
        propertiesGroup.setText("Template Properties");
        propertiesGroup.setLayout((Layout)new GridLayout(2, false));
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        layoutData.verticalIndent = 16;
        propertiesGroup.setLayoutData((Object)layoutData);
        processTemplateCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewBpelFileTemplatePage.this.processTemplateName = processTemplateCombo.getText();
                Templates.Template tpl = NewBpelFileTemplatePage.this.getSelectedTemplate();
                String desc = tpl == null ? "No description was found." : tpl.getDescription();
                descriptionText.setText(desc);
                NewBpelFileTemplatePage.this.refreshTemplateWidgets((Composite)propertiesGroup);
                NewBpelFileTemplatePage.this.updateStatus();
            }
        });
        processTemplateCombo.select(0);
        processTemplateCombo.notifyListeners(13, new Event());
        if (this.getErrorMessage() != null) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
        }
    }

    private void refreshTemplateWidgets(Composite container) {
        String tplKey;
        Control[] controlArray = container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        Label l = new Label(container, 0);
        l.setText(Messages.NewFileWizard_WSDLCustomPage_ServiceLable);
        this.serviceNameText = new Text(container, 2052);
        this.serviceNameText.setLayoutData((Object)new GridData(768));
        if (this.serviceName != null) {
            this.serviceNameText.setText(this.serviceName);
        }
        this.serviceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBpelFileTemplatePage.this.serviceName = ((Text)e.widget).getText();
                NewBpelFileTemplatePage.this.updateStatus();
            }
        });
        Templates.Template tpl = this.getSelectedTemplate();
        String string = tplKey = tpl == null ? null : tpl.getKey();
        if (!"empty".equals(tplKey)) {
            l = new Label(container, 0);
            l.setText(Messages.NewFileWizard_WSDLCustomPage_PortLabel);
            this.portNameText = new Text(container, 2052);
            this.portNameText.setLayoutData((Object)new GridData(768));
            if (this.portName != null) {
                this.portNameText.setText(this.portName);
            }
            this.portNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewBpelFileTemplatePage.this.portName = ((Text)e.widget).getText();
                    NewBpelFileTemplatePage.this.updateStatus();
                }
            });
            l = new Label(container, 0);
            l.setText(Messages.NewFileWizard_WSDLCustomPage_AddressLabel);
            this.addressText = new Text(container, 2052);
            this.addressText.setLayoutData((Object)new GridData(768));
            if (this.address != null) {
                this.addressText.setText(this.address);
            }
            this.addressText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewBpelFileTemplatePage.this.address = ((Text)e.widget).getText();
                    NewBpelFileTemplatePage.this.updateStatus();
                }
            });
            l = new Label(container, 0);
            l.setText(Messages.NewFileWizard_WSDLCustomPage_BindingLabel);
            Combo bindingCombo = new Combo(container, 2124);
            GridData layoutData = new GridData();
            layoutData.widthHint = 200;
            bindingCombo.setLayoutData((Object)layoutData);
            bindingCombo.setItems(new String[]{SOAP_BINDING, HTTP_BINDING});
            int index = HTTP_BINDING.equals(this.binding) ? 1 : 0;
            bindingCombo.select(index);
            bindingCombo.notifyListeners(13, new Event());
            bindingCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewBpelFileTemplatePage.this.binding = ((Combo)e.widget).getText();
                    NewBpelFileTemplatePage.this.updateStatus();
                }
            });
        }
        container.layout();
        container.getParent().layout();
    }

    public void setVisible(boolean visible) {
        String pName;
        if (this.serviceNameText != null && !this.serviceNameText.isDisposed() && (pName = this.getWizard().getDialogSettings().get("process-name")) != null) {
            this.serviceNameText.setText(String.valueOf(pName) + "Service");
            if (this.portNameText != null && !this.portNameText.isDisposed()) {
                this.portNameText.setText(String.valueOf(pName) + "Port");
            }
            if (this.addressText != null && !this.addressText.isDisposed()) {
                this.addressText.setText("http://localhost:8080/" + pName);
            }
        }
        super.setVisible(visible);
    }

    public Map<String, String> getProcessTemplateProperties() {
        return this.processTemplateProperties;
    }

    public Templates.Template getSelectedTemplate() {
        return this.processTemplateName == null ? null : BPELUIPlugin.INSTANCE.getTemplates().getTemplateByName(this.processTemplateName);
    }

    private void updateStatus() {
        String tplKey;
        String errorMsg = this.validatePage();
        this.setPageComplete(errorMsg == null);
        this.setErrorMessage(errorMsg);
        String msg = null;
        Templates.Template tpl = this.getSelectedTemplate();
        String string = tplKey = tpl == null ? null : tpl.getKey();
        if ("empty".equals(tplKey)) {
            msg = "Beware, empty processes are marked as invalid by the BPEL validator.";
        }
        this.setMessage(msg, 2);
    }

    private String validatePage() {
        String errorMsg = null;
        Templates.Template tpl = this.getSelectedTemplate();
        if (tpl == null) {
            errorMsg = "The selected template does not match a concrete one.";
        } else if (this.serviceName == null || this.serviceName.trim().length() == 0) {
            errorMsg = "You have to specify the service name.";
        } else if (this.serviceName.matches("\\s")) {
            errorMsg = "The service name cannot contain spaces or white characters.";
        }
        if (this.portName == null || this.portName.trim().length() == 0) {
            errorMsg = "You have to specify the port name.";
        } else if (this.portName.matches("\\s")) {
            errorMsg = "The port name cannot contain spaces or white characters.";
        }
        if (this.address == null || this.address.trim().length() == 0) {
            errorMsg = "You have to specify the service address.";
        } else if (this.address.matches("\\s")) {
            errorMsg = "The address cannot contain spaces or white characters.";
        }
        if (errorMsg == null) {
            this.processTemplateProperties.put("name", this.processTemplateName);
            this.processTemplateProperties.put("key", tpl.getKey());
            this.processTemplateProperties.put("serviceName", this.serviceName);
            this.processTemplateProperties.put("portName", this.portName);
            this.processTemplateProperties.put("address", this.address);
            this.processTemplateProperties.put("protocol", this.binding.toLowerCase());
            if (SOAP_BINDING.equals(this.binding)) {
                this.processTemplateProperties.put("protocolNamespace", SOAP_NAMESPACE);
            } else {
                this.processTemplateProperties.put("protocolNamespace", HTTP_NAMESPACE);
            }
        }
        return errorMsg;
    }
}

