/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts.policies;

import java.util.Collections;
import java.util.List;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.CompensateScope;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Source;
import org.eclipse.bpel.model.Target;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.BPELLinkCreationFactory;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.AddLinkCommand;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.ReplaceInContainerCommand;
import org.eclipse.bpel.ui.commands.SetCompensateCommand;
import org.eclipse.bpel.ui.commands.SetNameCommand;
import org.eclipse.bpel.ui.commands.SetPartnerLinkCommand;
import org.eclipse.bpel.ui.commands.SetVariableCommand;
import org.eclipse.bpel.ui.editparts.ActivityEditPart;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.PartnerLinkEditPart;
import org.eclipse.bpel.ui.editparts.VariableEditPart;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.FlowLinkUtil;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class BPELGraphicalEditPolicy
extends GraphicalNodeEditPolicy {
    private static final int FLOWLINK = 3;
    private static final int COMPENSATELINK = 4;

    private int getLinkMode(CreateConnectionRequest req) {
        if (req.getStartCommand().getClass().equals(SetCompensateCommand.class)) {
            return 4;
        }
        return 3;
    }

    protected Command createSetNameCommand(Link link, Process process) {
        if (link == null) {
            return null;
        }
        return new SetNameCommand((EObject)link, BPELUtil.getUniqueModelName((EObject)process, Messages.BPELGraphicalEditPolicy_link1_1, Collections.singletonList(link)));
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        if (this.getHost() == null) {
            return null;
        }
        if (request.getNewObjectType().equals(BPELPackage.eINSTANCE.getLink())) {
            Activity activity = this.getActivity();
            if (activity == null) {
                return null;
            }
            if (!FlowLinkUtil.hasParentFlow((EObject)activity)) {
                return null;
            }
            Link link = BPELFactory.eINSTANCE.createLink();
            Source source = BPELFactory.eINSTANCE.createSource();
            Target target = BPELFactory.eINSTANCE.createTarget();
            link.getSources().add((Object)source);
            link.getTargets().add((Object)target);
            Process process = BPELUtils.getProcess((Object)activity);
            AddLinkCommand command = new AddLinkCommand(this.createSetNameCommand(link, process), (EObject)process);
            command.setLink(link);
            command.setSource(activity);
            request.setStartCommand((Command)command);
            return command;
        }
        if (request.getNewObjectType().equals(BPELLinkCreationFactory.PartnerTempLink.class)) {
            Activity activity = this.getActivity();
            if (activity == null) {
                return null;
            }
            SetPartnerLinkCommand command = new SetPartnerLinkCommand((EObject)activity, null);
            request.setStartCommand((Command)command);
            return command;
        }
        if (request.getNewObjectType().equals(BPELLinkCreationFactory.IncomingVarTempLink.class)) {
            Activity activity = this.getActivity();
            if (activity == null) {
                return null;
            }
            SetVariableCommand command = new SetVariableCommand((EObject)activity, null, 1);
            request.setStartCommand((Command)command);
            return command;
        }
        if (request.getNewObjectType().equals(BPELLinkCreationFactory.CompensateTempLink.class)) {
            Activity activity = this.getActivity();
            if (activity == null) {
                return null;
            }
            SetCompensateCommand command = new SetCompensateCommand((CompensateScope)activity, null);
            request.setStartCommand((Command)command);
            return command;
        }
        if (request.getNewObjectType().equals(BPELLinkCreationFactory.OutgoingVarTempLink.class)) {
            Activity activity = this.getActivity();
            if (activity == null) {
                return null;
            }
            SetVariableCommand command = new SetVariableCommand((EObject)activity, null, 0);
            request.setStartCommand((Command)command);
            return command;
        }
        return null;
    }

    private PolylineConnection createConnection(ConnectionAnchor sourceAnchor, ConnectionAnchor targetAnchor, boolean sourceArrow, boolean targetArrow) {
        PolylineConnection connection = new PolylineConnection();
        if (sourceAnchor != null) {
            connection.setSourceAnchor(sourceAnchor);
        }
        if (targetAnchor != null) {
            connection.setTargetAnchor(targetAnchor);
        }
        connection.setForegroundColor(BPELUIPlugin.INSTANCE.getColorRegistry().get("COLOR_BLUE"));
        connection.setBackgroundColor(BPELUIPlugin.INSTANCE.getColorRegistry().get("COLOR_BLUE"));
        connection.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
        PolygonDecoration arrow = new PolygonDecoration();
        arrow.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        arrow.setScale(5.0, 2.5);
        arrow.setBackgroundColor(BPELUIPlugin.INSTANCE.getColorRegistry().get("COLOR_BLUE"));
        if (targetArrow) {
            connection.setTargetDecoration((RotatableDecoration)arrow);
        }
        if (sourceArrow) {
            connection.setSourceDecoration((RotatableDecoration)arrow);
        }
        this.getLayer("Connection Layer").add((IFigure)connection);
        return connection;
    }

    protected Connection createDummyConnection(Request req) {
        if (this.getLinkMode((CreateConnectionRequest)req) == 3) {
            return super.createDummyConnection(req);
        }
        return this.createConnection(null, null, false, true);
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        Command startCommand = request.getStartCommand();
        if (this.getLinkMode(request) == 3) {
            AddLinkCommand command = (AddLinkCommand)startCommand;
            Activity activity = this.getActivity();
            if (activity == null || !FlowLinkUtil.hasParentFlow((EObject)activity)) {
                return null;
            }
            command.setTarget(activity);
            if (!command.canExecute()) {
                return null;
            }
            ConnectionAnchor ctor = this.getActivityEditPart().getTargetConnectionAnchor((Request)request);
            if (ctor == null) {
                return null;
            }
            return command;
        }
        if (this.getLinkMode(request) == 4) {
            SetCompensateCommand command = (SetCompensateCommand)startCommand;
            Activity compensate = this.getActivity();
            boolean b = BPELUtil.getCompensableActivities(command.getTarget()).contains(compensate);
            if (compensate == null || !b) {
                return null;
            }
            command.setNewValue((EObject)compensate);
            if (!command.canExecute()) {
                return null;
            }
            ConnectionAnchor ctor = ((BPELEditPart)request.getTargetEditPart()).getConnectionAnchor(2);
            if (ctor == null) {
                return null;
            }
            return command;
        }
        return null;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Activity activity = this.getActivity();
        Link link = (Link)request.getConnectionEditPart().getModel();
        Process process = BPELUtils.getProcess((Object)activity);
        AddLinkCommand cmd = new AddLinkCommand(this.createSetNameCommand(link, process), (EObject)process);
        cmd.setLink(link);
        if (link.getSources().size() > 0) {
            cmd.setSource(((Source)link.getSources().get(0)).getActivity());
        }
        cmd.setTarget(activity);
        return cmd;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        Activity activity = this.getActivity();
        Link link = (Link)request.getConnectionEditPart().getModel();
        Process process = BPELUtils.getProcess((Object)activity);
        AddLinkCommand cmd = new AddLinkCommand(this.createSetNameCommand(link, process), (EObject)process);
        cmd.setLink(link);
        if (link.getTargets().size() > 0) {
            cmd.setTarget(((Target)link.getTargets().get(0)).getActivity());
        }
        cmd.setSource(activity);
        return cmd;
    }

    protected ActivityEditPart getActivityEditPart() {
        if (this.getHost() instanceof ActivityEditPart) {
            return (ActivityEditPart)this.getHost();
        }
        return null;
    }

    protected Activity getActivity() {
        ActivityEditPart ep = this.getActivityEditPart();
        if (ep == null) {
            return null;
        }
        return (Activity)ep.getModel();
    }

    protected PartnerLinkEditPart getPartnerEditPart() {
        EditPart ep = this.getHost();
        if (ep instanceof PartnerLinkEditPart) {
            return (PartnerLinkEditPart)this.getHost();
        }
        return null;
    }

    protected PartnerLink getPartnerLink() {
        if (!(this.getHost() instanceof PartnerLinkEditPart)) {
            return null;
        }
        Object model = this.getHost().getModel();
        return (PartnerLink)model;
    }

    protected Variable getVariable() {
        if (!(this.getHost() instanceof VariableEditPart)) {
            return null;
        }
        Object model = this.getHost().getModel();
        return (Variable)model;
    }

    protected ConnectionAnchor getSourceConnectionAnchor(CreateConnectionRequest request) {
        EditPart source = request.getSourceEditPart();
        if (source instanceof NodeEditPart) {
            if (this.getLinkMode(request) == 3) {
                return ((NodeEditPart)source).getSourceConnectionAnchor((Request)request);
            }
            return ((BPELEditPart)source).getConnectionAnchor(2);
        }
        return null;
    }

    protected ConnectionAnchor getTargetConnectionAnchor(CreateConnectionRequest request) {
        EditPart target = request.getTargetEditPart();
        if (target instanceof NodeEditPart) {
            if (!FlowLinkUtil.hasParentFlow((EObject)target.getModel())) {
                return null;
            }
            if (this.getLinkMode(request) == 3) {
                EditPart source = request.getSourceEditPart();
                Flow[] flows = FlowLinkUtil.getParentFlows((EObject)source.getModel());
                int i = 0;
                while (i < flows.length) {
                    List links = FlowLinkUtil.getFlowLinks(flows[i]);
                    int j = 0;
                    while (j < links.size()) {
                        Link link = (Link)links.get(j);
                        if (FlowLinkUtil.getLinkSource(link) == source.getModel() && FlowLinkUtil.getLinkTarget(link) == target.getModel()) {
                            return null;
                        }
                        ++j;
                    }
                    ++i;
                }
                return ((NodeEditPart)target).getTargetConnectionAnchor((Request)request);
            }
        } else {
            if (target instanceof PartnerLinkEditPart) {
                return ((BPELEditPart)target).getConnectionAnchor(2);
            }
            if (target instanceof VariableEditPart) {
                return ((BPELEditPart)target).getConnectionAnchor(3);
            }
        }
        return null;
    }

    public Command getCommand(Request request) {
        if ("changeType".equals(request.getType())) {
            return this.getReplaceInContainerCommand((CreateRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getReplaceInContainerCommand(CreateRequest request) {
        Object target = this.getHost().getParent().getModel();
        Object oldElement = this.getHost().getModel();
        Object newElement = request.getNewObject();
        if (!(oldElement instanceof Activity)) {
            return null;
        }
        CompoundCommand command = new CompoundCommand();
        command.add((Command)new ReplaceInContainerCommand(target, oldElement, newElement));
        return command;
    }
}

