/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeFile;
import org.eclipse.birt.core.btree.BTreeOption;
import org.eclipse.birt.core.btree.BTreeSerializer;
import org.eclipse.birt.core.btree.BTreeUtils;
import org.eclipse.birt.core.btree.FileBTreeFile;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.executor.ExecutionContext;

public class BookmarkManager {
    static final Integer VALUE = new Integer(0);
    int sequenceID = 0;
    BookmarkHashSet hashset;
    ExecutionContext context;

    public BookmarkManager(ExecutionContext context, int size) {
        this.context = context;
        this.hashset = new BookmarkHashSet(context, size);
    }

    public void close() {
        this.hashset.close();
    }

    public boolean exist(String bookmark) {
        try {
            return this.hashset.exist(bookmark);
        }
        catch (IOException ex) {
            this.context.addException(new EngineException(ex.getMessage(), ex));
            return false;
        }
    }

    public void addBookmark(String bookmark) {
        try {
            this.hashset.addBookmark(bookmark);
        }
        catch (IOException ex) {
            this.context.addException(new EngineException(ex.getMessage(), ex));
        }
    }

    public String createBookmark(String bookmark) {
        return "_recreated__bookmark__" + ++this.sequenceID;
    }

    private class BookmarkHashSet {
        protected HashMap<String, Integer> inlineMap = new HashMap();
        protected BTree<String, Integer> btree = null;
        protected String fileName;
        protected ExecutionContext context;
        protected int size;

        public BookmarkHashSet(ExecutionContext context, int size) {
            this.context = context;
            this.size = size;
        }

        public boolean exist(String bookmark) throws IOException {
            if (this.inlineMap != null) {
                return this.inlineMap.containsKey(bookmark);
            }
            if (this.btree == null) {
                this.btree = this.createBtree();
            }
            return this.btree.exist((Object)bookmark);
        }

        public void addBookmark(String bookmark) throws IOException {
            if (this.inlineMap != null) {
                if (this.inlineMap.size() < this.size) {
                    this.inlineMap.put(bookmark, VALUE);
                } else {
                    this.flush();
                    this.inlineMap = null;
                    this.btree.insert((Object)bookmark, (Object)VALUE);
                }
            } else {
                if (this.btree == null) {
                    this.btree = this.createBtree();
                }
                this.btree.insert((Object)bookmark, (Object)VALUE);
            }
        }

        protected void flush() throws IOException {
            if (this.btree == null) {
                this.btree = this.createBtree();
            }
            ArrayList<Map.Entry<String, Integer>> entries = new ArrayList<Map.Entry<String, Integer>>(this.inlineMap.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            for (Map.Entry<String, Integer> entry : entries) {
                this.btree.insert((Object)entry.getKey(), (Object)VALUE);
            }
        }

        protected BTree<String, Integer> createBtree() throws IOException {
            String tmpdir = this.context.getEngine().getConfig().getTempDir();
            this.fileName = String.valueOf(tmpdir) + File.separator + UUID.randomUUID();
            FileBTreeFile file = new FileBTreeFile(this.fileName);
            BTreeOption option = new BTreeOption();
            option.setHasValue(true);
            option.setKeySerializer((BTreeSerializer)new StringSerializer());
            option.setValueSerializer((BTreeSerializer)new IntegerSerializer());
            option.setValueSize(4);
            option.setFile((BTreeFile)file);
            return new BTree(option);
        }

        public void close() {
            this.inlineMap = null;
            if (this.btree != null) {
                try {
                    this.btree.close();
                    File file = new File(this.fileName);
                    if (file.exists()) {
                        file.delete();
                    }
                }
                catch (IOException e) {
                    this.context.addException(new EngineException(e.getMessage(), e));
                }
            }
        }
    }

    private static class IntegerSerializer
    implements BTreeSerializer<Integer> {
        private IntegerSerializer() {
        }

        public byte[] getBytes(Integer object) throws IOException {
            byte[] bytes = new byte[4];
            BTreeUtils.integerToBytes((int)object, (byte[])bytes);
            return bytes;
        }

        public Integer getObject(byte[] bytes) throws IOException, ClassNotFoundException {
            return new Integer(BTreeUtils.bytesToInteger((byte[])bytes));
        }
    }

    private static class StringSerializer
    implements BTreeSerializer<String> {
        private StringSerializer() {
        }

        public byte[] getBytes(String object) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            DataOutputStream oo = new DataOutputStream(out);
            oo.writeUTF(object);
            return out.toByteArray();
        }

        public String getObject(byte[] bytes) throws IOException, ClassNotFoundException {
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));
            return input.readUTF();
        }
    }
}

