/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class CellDragoicator
implements Locator {
    private double relativeX;
    private double relativeY;
    private IFigure reference;

    public CellDragoicator(IFigure reference, int location) {
        this.setReferenceFigure(reference);
        switch (location & 5) {
            case 4: {
                this.relativeY = 1.0;
                break;
            }
            default: {
                this.relativeY = 0.0;
            }
        }
        switch (location & 0x18) {
            case 16: {
                this.relativeX = 1.0;
                break;
            }
            default: {
                this.relativeX = 0.0;
            }
        }
    }

    protected Rectangle getReferenceBox() {
        return this.getReferenceFigure().getBounds();
    }

    protected IFigure getReferenceFigure() {
        return this.reference;
    }

    public void relocate(IFigure target) {
        IFigure reference = this.getReferenceFigure();
        PrecisionRectangle targetBounds = new PrecisionRectangle(this.getReferenceBox().getResized(-1, -1));
        reference.translateToAbsolute((Translatable)targetBounds);
        target.translateToRelative((Translatable)targetBounds);
        targetBounds.resize(1, 1);
        Dimension targetSize = this.getTargetSize(targetBounds.getSize());
        targetBounds.x += (int)((double)targetBounds.width * this.relativeX) - 1;
        targetBounds.y += (int)((double)targetBounds.height * this.relativeY);
        if (targetBounds.x < 0) {
            targetBounds.x = 0;
        }
        if (targetBounds.y < 0) {
            targetBounds.y = 0;
        }
        targetBounds.setSize(targetSize);
        target.setBounds((Rectangle)targetBounds);
    }

    private Dimension getTargetSize(Dimension size) {
        Dimension retValue = new Dimension((int)((double)size.width * this.relativeY), (int)((double)size.height * this.relativeX));
        retValue.width = Math.max(2, retValue.width);
        retValue.height = Math.max(2, retValue.height);
        return retValue;
    }

    public void setReferenceFigure(IFigure reference) {
        this.reference = reference;
    }
}

