/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import org.eclipse.birt.report.designer.internal.ui.editors.xml.XMLPartitionScanner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.ui.editors.text.FileDocumentProvider;
/**
 * Document provider specialized for IFileEditorInput
 */
public class ReportDocumentProvider extends FileDocumentProvider
{

	protected IDocument createDocument( Object element ) throws CoreException
	{
		IDocument document = super.createDocument( element );
		if ( document != null )
		{
			IDocumentPartitioner partitioner = new FastPartitioner( new XMLPartitionScanner( ),
					new String[]{
							XMLPartitionScanner.XML_TAG,
							XMLPartitionScanner.XML_COMMENT
					} );
			partitioner.connect( document );
			document.setDocumentPartitioner( partitioner );
		}
		return document;
	}
}
