/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.page;

import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.AbstractCubePropertyPage;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.CubeBuilder;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.CubeGroupContent;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.ICubeGroupContentProvider;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GroupsPage
extends AbstractCubePropertyPage {
    public static final String GROUPPAGE_MESSAGE = Messages.getString("GroupsPage.Title.Message");
    private TabularCubeHandle input;
    private CubeGroupContent cubeGroup;
    private CubeBuilder builder;

    public GroupsPage(CubeBuilder builder, TabularCubeHandle model) {
        this.input = model;
        this.builder = builder;
    }

    @Override
    public Control createContents(Composite parent) {
        this.cubeGroup = this.getCubeGroupContent(parent);
        return this.cubeGroup;
    }

    protected CubeGroupContent getCubeGroupContent(Composite parent) {
        Object[] contentProviders = ElementAdapterManager.getAdapters((Object)this.input, ICubeGroupContentProvider.class);
        if (contentProviders != null) {
            int i = 0;
            while (i < contentProviders.length) {
                ICubeGroupContentProvider contentProvider = (ICubeGroupContentProvider)contentProviders[i];
                if (contentProvider != null) {
                    return contentProvider.createGroupContent(parent, 0);
                }
                ++i;
            }
        }
        return new CubeGroupContent(parent, 0);
    }

    public void pageActivated() {
        UIUtil.bindHelp((Control)this.builder.getShell(), (String)"org.eclipse.birt.cshelp.CubeBuilderGroupsPage_ID");
        this.getContainer().setMessage(Messages.getString("GroupsPage.Container.Title.Message"), 0);
        this.builder.setTitleTitle(Messages.getString("GroupsPage.Title.Title"));
        this.builder.setErrorMessage(null);
        this.builder.setTitleMessage(GROUPPAGE_MESSAGE);
        this.load();
    }

    private void load() {
        if (this.input != null) {
            this.cubeGroup.setInput(this.input, null);
            this.cubeGroup.load();
        }
    }
}

