/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.launcher;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.debug.internal.core.launcher.IReportLaunchConstants;
import org.eclipse.birt.report.debug.internal.core.launcher.LauncherEngineConfig;
import org.eclipse.birt.report.debug.internal.core.launcher.ReportLauncher;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.ScriptDebugClasspathProvider;
import org.eclipse.birt.report.debug.internal.ui.script.util.ScriptDebugUtil;
import org.eclipse.birt.report.debug.ui.DebugUI;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.InputParameterDialog;
import org.eclipse.birt.report.designer.ui.parameters.ParameterFactory;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;

public class ReportLaunchHelper
implements IReportLaunchConstants {
    private Map paramValues = new HashMap();
    String fileName;
    String engineHome;
    String tempFolder;
    String targetFormat;
    boolean isOpenTargetFile;
    int debugType;
    int taskType;
    int listenPort;

    void init(ILaunchConfiguration configuration) throws CoreException {
        this.fileName = ReportLaunchHelper.covertVariables(configuration.getAttribute("report.file.name", ""));
        this.engineHome = ReportLaunchHelper.covertVariables(configuration.getAttribute("engine.home", ""));
        this.tempFolder = ReportLaunchHelper.covertVariables(configuration.getAttribute("temp.folder", ""));
        this.targetFormat = configuration.getAttribute("engine.target.format", "html");
        this.isOpenTargetFile = configuration.getAttribute("open.target.file", false);
        this.debugType = configuration.getAttribute("engine.debug.type", 2);
        this.taskType = configuration.getAttribute("engine.task.type", 4);
    }

    void addUserClassPath(List list, ILaunchConfiguration config) {
        list.add("-Dreport.user.class.path=" + ReportLaunchHelper.convertClassPath(ReportLaunchHelper.getUserClasspath(config)));
    }

    void addResourceFolder(List list) {
        String str = this.getResourceFolder(this.fileName);
        if (str != null) {
            list.add("-Duse.resource.folder=" + str);
        }
    }

    private String getResourceFolder(String fileName) {
        Path path = new Path(fileName);
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
        if (files == null || files.length == 0) {
            return null;
        }
        return ReportPlugin.getDefault().getResourceFolder(files[0].getProject());
    }

    void addPortArgs(List list) {
        this.listenPort = ReportLaunchHelper.findFreePort();
        list.add("-Dreport.listen.port=" + this.listenPort);
    }

    void addParameterArgs(List list) {
        for (String key : this.paramValues.keySet()) {
            Object obj = this.paramValues.get(key);
            if (obj == null) {
                obj = "NULL NULL NULL NULL NULL VALUE";
            }
            if (obj instanceof Object[]) {
                Object[] temp = (Object[])obj;
                int i = 0;
                while (i < temp.length) {
                    String value = String.valueOf(temp[i]);
                    StringBuffer buff = new StringBuffer();
                    buff.append("-D");
                    buff.append("mulparam:");
                    buff.append(i);
                    buff.append(key);
                    buff.append("=");
                    buff.append(value);
                    list.add(buff.toString());
                    ++i;
                }
                continue;
            }
            String value = null;
            value = obj instanceof Date ? String.valueOf(((Date)obj).getTime()) : String.valueOf(obj);
            StringBuffer buff = new StringBuffer();
            buff.append("-D");
            buff.append("param:");
            buff.append(key);
            buff.append("=");
            buff.append(value);
            list.add(buff.toString());
        }
    }

    void addDataLimitArgs(List list) {
        String value = ReportPlugin.getDefault().getPluginPreferences().getString("org.eclipse.birt.designer.ui.preference.datamodel.limit.preferencestore");
        StringBuffer buff = new StringBuffer();
        buff.append("-D");
        buff.append("data.limit");
        buff.append("=");
        buff.append(value);
        list.add(buff.toString());
    }

    void addTypeArgs(List list) {
        list.add("-Dengine.debug.type=" + this.debugType);
        list.add("-Dengine.task.type=" + this.taskType);
        list.add("-Dengine.target.format=" + this.targetFormat);
    }

    void addTempFolder(List list) {
        list.add("-Dtemp.folder=" + this.tempFolder);
    }

    void addFileNameArgs(List list) {
        list.add("-Dreport.file.name=" + this.fileName);
    }

    void addEngineHomeArgs(List list) {
        list.add("-Dengine.home=" + this.engineHome);
    }

    private static String covertVariables(String str) {
        try {
            return ScriptDebugUtil.getSubstitutedString(str);
        }
        catch (CoreException coreException) {
            return str;
        }
    }

    private static String[] getUserClasspath(ILaunchConfiguration configuration) {
        try {
            ScriptDebugClasspathProvider provider = new ScriptDebugClasspathProvider();
            IRuntimeClasspathEntry[] entries = provider.computeUserClasspath(configuration);
            entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
            ArrayList<String> userEntries = new ArrayList<String>();
            HashSet<String> set = new HashSet<String>(entries.length);
            int i = 0;
            while (i < entries.length) {
                String location;
                if (entries[i].getClasspathProperty() == 3 && (location = entries[i].getLocation()) != null && !set.contains(location)) {
                    userEntries.add(location);
                    set.add(location);
                }
                ++i;
            }
            return userEntries.toArray(new String[userEntries.size()]);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String convertClassPath(String[] cp) {
        int pathCount = 0;
        StringBuffer buf = new StringBuffer();
        if (cp == null || cp.length == 0) {
            return "";
        }
        int i = 0;
        while (i < cp.length) {
            if (pathCount > 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(cp[i]);
            ++pathCount;
            ++i;
        }
        return buf.toString();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findFreePort() {
        ServerSocket socket = null;
        socket = new ServerSocket(0);
        int n = socket.getLocalPort();
        if (socket == null) return n;
        try {
            socket.close();
            return n;
        }
        catch (IOException iOException) {}
        return n;
        catch (IOException iOException) {
            try {
                if (socket == null) return -1;
            }
            catch (Throwable throwable) {
                if (socket == null) throw throwable;
                try {
                    socket.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                socket.close();
                return -1;
            }
            catch (IOException iOException3) {}
            return -1;
        }
    }

    private static boolean getParameterValues(List params, Map paramValues) {
        if (params != null && params.size() > 0) {
            InputParameterDialog dialog = new InputParameterDialog(DebugUI.getShell(), params, paramValues);
            if (dialog.open() == 0) {
                paramValues.clear();
                paramValues.putAll(dialog.getParameters());
                return true;
            }
            return false;
        }
        return true;
    }

    private static List getInputParameters(String reportDesignFile, int taskType, IReportEngine engine) {
        IGetParameterDefinitionTask task = null;
        IReportDocument document = null;
        try {
            if (taskType == 2) {
                document = engine.openReportDocument(reportDesignFile);
                task = engine.createGetParameterDefinitionTask(document.getReportRunnable());
            } else {
                task = engine.createGetParameterDefinitionTask(engine.openReportDesign(reportDesignFile));
            }
            ParameterFactory factory = new ParameterFactory(task);
            List parameters = factory.getRootChildren(false);
            task.close();
            if (document != null) {
                document.close();
            }
            task = null;
            return parameters;
        }
        catch (EngineException engineException) {
            if (task != null) {
                task.close();
            }
            return null;
        }
    }

    boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        this.paramValues = new HashMap();
        LauncherEngineConfig engineConfig = new LauncherEngineConfig();
        IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
        final IReportEngine engine = factory.createReportEngine((EngineConfig)engineConfig);
        engine.changeLogLevel(Level.WARNING);
        final String fileName = ReportLaunchHelper.covertVariables(configuration.getAttribute("report.file.name", ""));
        if (this.getResourceFolder(fileName) != null) {
            engineConfig.setResourcePath(this.getResourceFolder(fileName));
        }
        final int taskType = configuration.getAttribute("engine.task.type", 4);
        Display display = DebugUI.getStandardDisplay();
        if (display.getThread().equals(Thread.currentThread())) {
            return ReportLaunchHelper.getParameterValues(ReportLaunchHelper.getInputParameters(fileName, taskType, engine), this.paramValues);
        }
        final Object[] result = new Object[]{Boolean.FALSE};
        Runnable r = new Runnable(){

            @Override
            public void run() {
                result[0] = ReportLaunchHelper.getParameterValues(ReportLaunchHelper.getInputParameters(fileName, taskType, engine), ReportLaunchHelper.this.paramValues);
            }
        };
        DebugUI.getStandardDisplay().syncExec(r);
        return (Boolean)result[0];
    }

    static void handleProcessTermination(ILaunch launch, final IProcess process, final String fileName, final String outputFolder) throws CoreException {
        if (launch.getLaunchConfiguration().getAttribute("open.target.file", false) && launch.getLaunchConfiguration().getAttribute("engine.task.type", 4) != 1) {
            final String suffix = launch.getLaunchConfiguration().getAttribute("engine.target.format", "html");
            Thread monitorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!process.isTerminated()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    DebugUI.getStandardDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                File file;
                                String openName;
                                if (process.getExitValue() == 1 && (openName = ReportLauncher.getOutputFileName((String)outputFolder, (String)(file = new File(fileName)).getName(), (String)suffix)) != null && new File(openName).exists()) {
                                    Program.launch((String)openName);
                                }
                            }
                            catch (DebugException debugException) {}
                        }
                    });
                }
            }, "Process Termination Monitor");
            monitorThread.setDaemon(true);
            monitorThread.start();
        }
    }
}

