/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.chart;

import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Interactivity;
import org.eclipse.birt.chart.model.attribute.impl.InteractivityImpl;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.InteractivitySheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.TitleBlockSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.TitleTextSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ChartTitleSheetImpl
extends SubtaskSheetImpl
implements SelectionListener,
Listener {
    private ExternalizedTextEditorComposite txtTitle = null;
    private FontDefinitionComposite fdcFont;
    private ChartCheckbox btnVisible;
    private ChartCheckbox btnAutoTitle;

    @Override
    public void createControl(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartTitle_ID");
        TitleBlock defTitle = ChartDefaultValueUtil.getDefaultValueChart((Chart)((Chart)this.getChart())).getTitle();
        this.init();
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        Composite cmpBasic = new Composite(this.cmpContent, 0);
        cmpBasic.setLayout((Layout)new GridLayout(4, false));
        GridData gd2 = new GridData(1808);
        cmpBasic.setLayoutData((Object)gd2);
        Label lblTitle = new Label(cmpBasic, 0);
        lblTitle.setText(Messages.getString("ChartTitleSheetImpl.Label.ChartTitle"));
        List keys = null;
        if (((ChartWizardContext)this.getContext()).getUIServiceProvider() != null) {
            keys = ((ChartWizardContext)this.getContext()).getUIServiceProvider().getRegisteredKeys();
        }
        this.txtTitle = new ExternalizedTextEditorComposite(cmpBasic, 2048, -1, -1, keys, ((ChartWizardContext)this.getContext()).getUIServiceProvider(), this.getTitleText());
        GridData gdTXTTitle = new GridData();
        gdTXTTitle.widthHint = 200;
        this.txtTitle.setLayoutData(gdTXTTitle);
        this.txtTitle.setEnabled(this.isTitleEnabled());
        this.txtTitle.addListener(this);
        this.btnVisible = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCheckbox(cmpBasic, 0, defTitle.isVisible());
        this.btnVisible.setText(Messages.getString("ChartSheetImpl.Label.Visible"));
        GridData gd3 = new GridData();
        this.btnVisible.setLayoutData((Object)gd3);
        this.btnVisible.setSelectionState(((Chart)this.getChart()).getTitle().isSetVisible() ? (((Chart)this.getChart()).getTitle().isVisible() ? 1 : 2) : 0);
        this.btnVisible.addSelectionListener((SelectionListener)this);
        boolean dynamicTitleVisible = ((ChartWizardContext)this.getContext()).getUIFactory().createUIHelper().isDefaultTitleSupported();
        this.btnAutoTitle = new ChartCheckbox(cmpBasic, 0, defTitle.isAuto());
        this.btnAutoTitle.setText(Messages.getString("ChartTitleSheetImpl.Text.Auto"));
        gd3 = new GridData();
        this.btnAutoTitle.setLayoutData((Object)gd3);
        this.btnAutoTitle.setSelectionState(((Chart)this.getChart()).getTitle().isSetAuto() ? (((Chart)this.getChart()).getTitle().isAuto() ? 1 : 2) : 0);
        this.btnAutoTitle.setEnabled(this.isAutoEnabled());
        this.btnAutoTitle.setVisible(dynamicTitleVisible);
        this.btnAutoTitle.addSelectionListener((SelectionListener)this);
        Label lblFont = new Label(cmpBasic, 0);
        lblFont.setText(Messages.getString("LabelAttributesComposite.Lbl.Font"));
        this.fdcFont = new FontDefinitionComposite(cmpBasic, 0, (ChartWizardContext)this.getContext(), ((Chart)this.getChart()).getTitle().getLabel().getCaption().getFont(), ((Chart)this.getChart()).getTitle().getLabel().getCaption().getColor(), this.getFontDialogStyles());
        GridData gdFDCFont = new GridData();
        gdFDCFont.widthHint = 220;
        gdFDCFont.horizontalSpan = 3;
        gdFDCFont.grabExcessVerticalSpace = false;
        this.fdcFont.setLayoutData(gdFDCFont);
        this.fdcFont.addListener(this);
        this.createButtonGroup(this.cmpContent);
        this.updateUIState(((ChartWizardContext)this.getContext()).getUIFactory().canEnableUI(this.btnVisible));
    }

    private void init() {
        if (((Chart)this.getChart()).getInteractivity() == null) {
            Interactivity interactivity = InteractivityImpl.create();
            interactivity.eAdapters().addAll((Collection)((Chart)this.getChart()).eAdapters());
            ((Chart)this.getChart()).setInteractivity(interactivity);
        }
    }

    protected void createButtonGroup(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(5, false));
        GridData gridData = new GridData(768);
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        AbstractPopupSheet popup = new TitleTextSheet(Messages.getString("ChartTitleSheetImpl.Text.TitleText"), (ChartWizardContext)this.getContext());
        Button btnTitleProp = this.createToggleButton(cmp, ".Text", Messages.getString("ChartTitleSheetImpl.Text.TitleText&"), popup, ((Chart)this.getChart()).getTitle().isVisible());
        btnTitleProp.addSelectionListener((SelectionListener)this);
        popup = new TitleBlockSheet(Messages.getString("ChartTitleSheetImpl.Text.TitleLayout"), (ChartWizardContext)this.getContext());
        Button btnBlockProp = this.createToggleButton(cmp, ".Layout", Messages.getString("ChartTitleSheetImpl.Text.Layout&"), popup, ((Chart)this.getChart()).getTitle().isVisible());
        btnBlockProp.addSelectionListener((SelectionListener)this);
        if (((ChartWizardContext)this.getContext()).isInteractivityEnabled()) {
            popup = new InteractivitySheet(Messages.getString("ChartTitleSheetImpl.Label.Interactivity"), (ChartWizardContext)this.getContext(), (EList<Trigger>)((Chart)this.getChart()).getTitle().getTriggers(), (EObject)((Chart)this.getChart()).getTitle(), 2, 16);
            Button btnInteractivity = this.createToggleButton(cmp, ".Interactivity", Messages.getString("SeriesYSheetImpl.Label.Interactivity&"), popup, ((Chart)this.getChart()).getInteractivity().isEnable());
            btnInteractivity.addSelectionListener((SelectionListener)this);
        }
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.txtTitle)) {
            String title = this.txtTitle.getText();
            if (!(this.btnAutoTitle.getSelectionState() != 0 && this.btnAutoTitle.getSelectionState() != 2 || this.txtTitle.getText() != null && this.txtTitle.getText().trim().length() != 0)) {
                title = null;
            }
            ((Chart)this.getChart()).getTitle().getLabel().getCaption().setValue(title);
        } else if (event.widget.equals((Object)this.fdcFont) && event.type == 1) {
            ((Chart)this.getChart()).getTitle().getLabel().getCaption().setFont((FontDefinition)((Object[])event.data)[0]);
            ((Chart)this.getChart()).getTitle().getLabel().getCaption().setColor((ColorDefinition)((Object[])event.data)[1]);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getData().toString());
        }
        if (e.widget.equals(this.btnVisible)) {
            boolean visible;
            boolean bl = visible = this.btnVisible.getSelectionState() == 1;
            if (this.btnVisible.getSelectionState() == 0) {
                ((Chart)this.getChart()).getTitle().unsetVisible();
            } else {
                ((Chart)this.getChart()).getTitle().setVisible(visible);
            }
            this.updateUIState(((ChartWizardContext)this.getContext()).getUIFactory().canEnableUI(this.btnVisible));
            if (this.getToggleButtonSelection(".Text") || this.getToggleButtonSelection(".Layout")) {
                this.detachPopup();
            }
        } else if (e.widget.equals(this.btnAutoTitle)) {
            if (this.btnAutoTitle.getSelectionState() == 0) {
                ((Chart)this.getChart()).getTitle().unsetAuto();
                ((Chart)this.getChart()).getTitle().getLabel().getCaption().setValue(null);
            } else {
                ((Chart)this.getChart()).getTitle().setAuto(this.btnAutoTitle.getSelectionState() == 1);
                if (this.btnAutoTitle.getSelectionState() == 2) {
                    ((Chart)this.getChart()).getTitle().getLabel().getCaption().setValue(ChartUtil.getDefaultChartTitle((Chart)((Chart)this.getChart())));
                }
            }
            this.updateTextTitleState();
        }
    }

    protected void updateTextTitleState() {
        this.txtTitle.setEnabled(this.isTitleEnabled());
        this.txtTitle.setText(this.getTitleText());
    }

    protected void updateUIState(boolean enabled) {
        this.txtTitle.setEnabled(this.isTitleEnabled());
        if (this.btnAutoTitle != null) {
            this.btnAutoTitle.setEnabled(this.isAutoEnabled());
        }
        this.setToggleButtonEnabled(".Text", enabled);
        this.setToggleButtonEnabled(".Layout", enabled);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private boolean isAutoEnabled() {
        return !((ChartWizardContext)this.getContext()).getUIFactory().isSetInvisible((EObject)((Chart)this.getChart()).getTitle());
    }

    private boolean isTitleEnabled() {
        return !((ChartWizardContext)this.getContext()).getUIFactory().isSetInvisible((EObject)((Chart)this.getChart()).getTitle()) && !this.isAutoTitle();
    }

    protected boolean isAutoTitle() {
        return ((Chart)this.getChart()).getTitle().isSetAuto() && ((Chart)this.getChart()).getTitle().isAuto();
    }

    protected int getFontDialogStyles() {
        return 3;
    }

    private String getTitleText() {
        if (((Chart)this.getChart()).getTitle().isAuto() && ((ChartWizardContext)this.getContext()).getExtendedItem() != null) {
            return ((ChartWizardContext)this.getContext()).getUIFactory().createUIHelper().getDefaultTitle((ChartWizardContext)this.getContext());
        }
        String title = ((Chart)this.getChart()).getTitle().getLabel().getCaption().getValue();
        return title == null ? "" : title;
    }
}

