/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ui.util.timer;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.eclipse.actf.ui.util.timer.SyncEventListener;
import org.eclipse.swt.widgets.Display;

public class WeakSyncTimer
extends Thread {
    private ArrayList<WeakReference<SyncEventListener>> listeners = new ArrayList();
    private WeakHashMap<SyncEventListener, Long> entries = new WeakHashMap();
    private long nextWakeup = Long.MAX_VALUE;
    private Display display;
    private static WeakSyncTimer instance;

    public synchronized void run() {
        block2: while (true) {
            long l;
            if (this.nextWakeup > (l = System.currentTimeMillis())) {
                try {
                    long l2 = this.nextWakeup - System.currentTimeMillis() - 1L;
                    if (l2 > 0L) {
                        this.wait(l2);
                    } else {
                        this.wait(1L);
                    }
                }
                catch (InterruptedException interruptedException) {}
                l = System.currentTimeMillis();
            }
            Iterator<WeakReference<SyncEventListener>> iterator = this.listeners.iterator();
            this.nextWakeup = Long.MAX_VALUE;
            while (true) {
                if (!iterator.hasNext()) continue block2;
                SyncEventListener syncEventListener = (SyncEventListener)iterator.next().get();
                if (syncEventListener == null) {
                    iterator.remove();
                    continue;
                }
                Long l3 = this.entries.get(syncEventListener);
                if (l3 == null) {
                    iterator.remove();
                    continue;
                }
                long l4 = l3;
                if (l4 <= l) {
                    if (!this.display.isDisposed()) {
                        this.display.asyncExec((Runnable)syncEventListener);
                        this.manage(syncEventListener);
                        continue;
                    }
                    iterator.remove();
                    continue;
                }
                if (this.nextWakeup <= l4) continue;
                this.nextWakeup = l4;
            }
            break;
        }
    }

    private void manage(SyncEventListener syncEventListener) {
        long l = (long)(syncEventListener.getInterval() * 1000.0);
        if (l > 0L) {
            long l2 = System.currentTimeMillis() + l;
            this.entries.put(syncEventListener, l2);
            if (l2 < this.nextWakeup) {
                this.nextWakeup = l2;
            }
        } else {
            this.entries.remove(syncEventListener);
        }
    }

    public synchronized void addEventListener(SyncEventListener syncEventListener) {
        this.listeners.add(new WeakReference<SyncEventListener>(syncEventListener));
        this.manage(syncEventListener);
        this.notify();
    }

    public synchronized void removeEventListener(SyncEventListener syncEventListener) {
        this.entries.remove(syncEventListener);
    }

    public static WeakSyncTimer getTimer() {
        if (instance == null) {
            instance = new WeakSyncTimer(Display.getCurrent());
            instance.start();
        }
        return instance;
    }

    private WeakSyncTimer(Display display) {
        super("WeakSyncTimer-scheduler");
        this.display = display;
    }
}

