/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.examples.adesigner.eval.odf;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.actf.examples.adesigner.eval.odf.OdfCheckerEngineBase;
import org.eclipse.actf.examples.adesigner.eval.odf.OdfCheckerUtil;
import org.eclipse.actf.model.dom.odf.base.DrawingObjectElement;
import org.eclipse.actf.model.dom.odf.base.EmbedDrawingObjectElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.draw.ControlElement;
import org.eclipse.actf.model.dom.odf.draw.ImageElement;
import org.eclipse.actf.model.dom.odf.draw.ImageMapAreaElement;
import org.eclipse.actf.model.dom.odf.draw.ObjectElement;
import org.eclipse.actf.model.dom.odf.draw.ObjectOleElement;
import org.eclipse.actf.model.dom.odf.draw.PageElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.dom.odf.text.AElement;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfCheckerEngineImpl
extends OdfCheckerEngineBase {
    public OdfCheckerEngineImpl(Document document, Document document2) {
        super(document, document2);
    }

    private Element findElementByODFContentID(Document document, String string) {
        NodeList nodeList;
        if (this.target != null && (nodeList = this.target.getElementsByTagName("body")).getLength() > 0) {
            Stack<Node> stack = new Stack<Node>();
            Node node = nodeList.item(0);
            while (node != null) {
                Element element;
                String string2;
                if (node.getNodeType() == 1 && string.equals(string2 = (element = (Element)node).getAttribute("actf-odf-content-id"))) {
                    return element;
                }
                if (node.hasChildNodes()) {
                    stack.push(node);
                    node = node.getFirstChild();
                    continue;
                }
                if (node.getNextSibling() != null) {
                    node = node.getNextSibling();
                    continue;
                }
                node = null;
                while (node == null && stack.size() > 0) {
                    node = (Node)stack.pop();
                    node = node.getNextSibling();
                }
            }
        }
        return null;
    }

    protected void addProblems(int n, String string, Vector<Node> vector) {
        Iterator<Node> iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.addProblem(n, iterator.next(), string);
        }
    }

    @Override
    public Vector<IProblemItem> check() {
        if (this.detectVersion) {
            this.targetODF = this.checkOdfVersion(this.targetODF);
        }
        this.check101();
        this.check201();
        this.check301();
        this.check401();
        this.check50101();
        this.check601();
        this.check70101();
        this.check801();
        return this.resultV;
    }

    private Document checkOdfVersion(Document document) {
        List<DocumentContentElement> list;
        double d;
        if (document instanceof ODFDocument && (d = ((ODFDocument)document).getODFVersion()) == 1.0 && (list = OdfCheckerUtil.getInstance().getODF10CompativilityError(document)).size() != 0) {
            ((ODFDocument)document).setODFVersion(1.1);
            DocumentContentElement documentContentElement = list.get(0);
            Element element = this.findElementByODFContentID(this.target, documentContentElement.getAttribute("actf-odf-content-id"));
            this.addProblem(90101, element, null);
        }
        return document;
    }

    private void check101() {
        this.check10101();
        this.check10102();
    }

    private void check201() {
        this.check20101();
        this.check20102();
    }

    private void check301() {
        this.check30101();
        this.check30102();
    }

    private void check401() {
        this.check40101();
        this.check40102();
    }

    private void check601() {
        this.check60101();
        this.check60102();
    }

    private void check801() {
        this.check80101();
        this.check80102();
        this.check80103();
    }

    private void check10101() {
        List<ImageElement> list = OdfCheckerUtil.getInstance().getImageShortDescError(this.targetODF);
        int n = 0;
        while (n < list.size()) {
            ImageElement imageElement = list.get(n);
            Element element = this.findElementByODFContentID(this.target, imageElement.getAttribute("actf-odf-content-id"));
            this.addProblem(10101, element, null);
            ++n;
        }
    }

    private void check10102() {
        List<ImageElement> list = OdfCheckerUtil.getInstance().getImageLongDescError(this.targetODF);
        int n = 0;
        while (n < list.size()) {
            ImageElement imageElement = list.get(n);
            Element element = this.findElementByODFContentID(this.target, imageElement.getAttribute("actf-odf-content-id"));
            this.addProblem(10102, element, null);
            ++n;
        }
    }

    private void check20101() {
        List<TableElement> list = OdfCheckerUtil.getInstance().getTableHeaderError(this.targetODF);
        int n = 0;
        while (n < list.size()) {
            TableElement tableElement = list.get(n);
            Element element = this.findElementByODFContentID(this.target, tableElement.getAttribute("actf-odf-content-id"));
            this.addProblem(20101, element, null);
            ++n;
        }
    }

    private void check20102() {
        List<TableElement> list = OdfCheckerUtil.getInstance().getTableCaptionError(this.targetODF);
        int n = 0;
        while (n < list.size()) {
            TableElement tableElement = list.get(n);
            Element element = this.findElementByODFContentID(this.target, tableElement.getAttribute("actf-odf-content-id"));
            this.addProblem(20102, element, null);
            ++n;
        }
    }

    private void check30101() {
        List<ImageMapAreaElement> list = OdfCheckerUtil.getInstance().getImageMapShortDescError(this.targetODF);
        int n = 0;
        while (n < list.size()) {
            ImageMapAreaElement imageMapAreaElement = list.get(n);
            Element element = this.findElementByODFContentID(this.target, imageMapAreaElement.getAttribute("actf-odf-content-id"));
            this.addProblem(30101, element, null);
            ++n;
        }
    }

    private void check30102() {
        List<ImageMapAreaElement> list = OdfCheckerUtil.getInstance().getImageMapLongDescError(this.targetODF);
        int n = 0;
        while (n < list.size()) {
            ImageMapAreaElement imageMapAreaElement = list.get(n);
            Element element = this.findElementByODFContentID(this.target, imageMapAreaElement.getAttribute("actf-odf-content-id"));
            this.addProblem(30102, element, null);
            ++n;
        }
    }

    private void check40101() {
        List<DrawingObjectElement> list = OdfCheckerUtil.getInstance().getNotGroupDrawingObjectShortDescError(this.targetODF);
        list.addAll(OdfCheckerUtil.getInstance().getGroupObjectShortDescError(this.targetODF));
        int n = 0;
        while (n < list.size()) {
            DrawingObjectElement drawingObjectElement = list.get(n);
            if (drawingObjectElement instanceof DrawingObjectElement) {
                DrawingObjectElement drawingObjectElement2 = drawingObjectElement;
                Element element = this.findElementByODFContentID(this.target, drawingObjectElement2.getAttribute("actf-odf-content-id"));
                this.addProblem(40101, element, null);
            }
            ++n;
        }
    }

    private void check40102() {
        List<DrawingObjectElement> list = OdfCheckerUtil.getInstance().getDrawingObjectLongDescError(this.targetODF);
        int n = 0;
        while (n < list.size()) {
            DrawingObjectElement drawingObjectElement = list.get(n);
            Element element = this.findElementByODFContentID(this.target, drawingObjectElement.getAttribute("actf-odf-content-id"));
            this.addProblem(40102, element, null);
            ++n;
        }
    }

    private void check50101() {
        List<AElement> list = OdfCheckerUtil.getInstance().getLinkHintError(this.targetODF);
        int n = 0;
        while (n < list.size()) {
            AElement aElement = list.get(n);
            Element element = this.findElementByODFContentID(this.target, aElement.getAttribute("actf-odf-content-id"));
            this.addProblem(50101, element, null);
            ++n;
        }
    }

    private void check60101() {
        List<EmbedDrawingObjectElement> list = OdfCheckerUtil.getInstance().getEmbedObjectShortDescError(this.targetODF);
        int n = 0;
        while (n < list.size()) {
            EmbedDrawingObjectElement embedDrawingObjectElement = list.get(n);
            if (embedDrawingObjectElement instanceof ObjectElement || embedDrawingObjectElement instanceof ObjectOleElement) {
                Element element = this.findElementByODFContentID(this.target, embedDrawingObjectElement.getAttribute("actf-odf-content-id"));
                this.addProblem(60101, element, null);
            }
            ++n;
        }
    }

    private void check60102() {
        List<EmbedDrawingObjectElement> list = OdfCheckerUtil.getInstance().getEmbedObjectLongDescError(this.targetODF);
        int n = 0;
        while (n < list.size()) {
            EmbedDrawingObjectElement embedDrawingObjectElement = list.get(n);
            if (embedDrawingObjectElement instanceof ObjectElement || embedDrawingObjectElement instanceof ObjectOleElement) {
                Element element = this.findElementByODFContentID(this.target, embedDrawingObjectElement.getAttribute("actf-odf-content-id"));
                this.addProblem(60102, element, null);
            }
            ++n;
        }
    }

    private void check70101() {
        List<ControlElement> list = OdfCheckerUtil.getInstance().getFormLabelError(this.targetODF);
        int n = 0;
        while (n < list.size()) {
            ControlElement controlElement = list.get(n);
            Element element = this.findElementByODFContentID(this.target, controlElement.getAttribute("actf-odf-content-id"));
            this.addProblem(70101, element, null);
            ++n;
        }
    }

    private void check80101() {
        List<PageElement> list = OdfCheckerUtil.getInstance().getDrawNavOrderError(this.targetODF);
        int n = 0;
        while (n < list.size()) {
            PageElement pageElement = list.get(n);
            Element element = this.findElementByODFContentID(this.target, pageElement.getAttribute("actf-odf-content-id"));
            this.addProblem(80101, element, null);
            ++n;
        }
    }

    private void check80102() {
        List<DocumentContentElement> list = OdfCheckerUtil.getInstance().getFormTabIndexError(this.targetODF);
        int n = 0;
        while (n < list.size()) {
            DocumentContentElement documentContentElement = list.get(n);
            Element element = this.findElementByODFContentID(this.target, documentContentElement.getAttribute("actf-odf-content-id"));
            this.addProblem(80102, element, null);
            ++n;
        }
    }

    private void check80103() {
        List<ControlElement> list = OdfCheckerUtil.getInstance().getFormTabStopError(this.targetODF);
        int n = 0;
        while (n < list.size()) {
            ControlElement controlElement = list.get(n);
            Element element = this.findElementByODFContentID(this.target, controlElement.getAttribute("actf-odf-content-id"));
            this.addProblem(80103, element, null);
            ++n;
        }
    }
}

