/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.command;

import org.eclipse.actf.util.command.DefaultArgumentResolver;
import org.eclipse.actf.util.command.IArgumentResolver;

public class CLSwitch {
    private String _name;
    private String _prefix = "-";
    private String _description = "";
    private String _value;
    private Object _resolvedValue;
    private String _defaultValue = "";
    private Class _type = Object.class;
    private boolean _required = false;
    private int _expectedArgs = 1;
    private IArgumentResolver _resolver;

    public CLSwitch(String string, String string2, Class clazz) {
        this(string, string2, clazz, false);
    }

    public CLSwitch(String string, String string2, IArgumentResolver iArgumentResolver) {
        this(string, null, null, false, iArgumentResolver);
    }

    public CLSwitch(String string, String string2, Class clazz, boolean bl) {
        this(string, string2, clazz, bl, null);
    }

    public CLSwitch(String string, String string2, Class clazz, boolean bl, IArgumentResolver iArgumentResolver) {
        this.setName(string);
        this.setDescription(string2);
        this.setValueType(clazz);
        this.setRequired(bl);
        this.setArgumentResolver(iArgumentResolver);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Switch names may not be null");
        }
        if (!Character.isLetter(string.charAt(0))) {
            throw new IllegalArgumentException("Switch names must begin with a letter: " + string);
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isLetter(string.charAt(n)) && !Character.isDigit(string.charAt(n))) {
                throw new IllegalArgumentException("Switch names must be alpha-numeric: " + string);
            }
            ++n;
        }
        this._name = string;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public void setPrefix(String string) {
        this._prefix = string == null ? "-" : string;
    }

    public String getFullSwitchName() {
        return String.valueOf(this._prefix) + this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String string) {
        this._description = string == null ? "" : string;
    }

    public int getExpectedNumberOfArgs() {
        return this._expectedArgs;
    }

    public void setExpectedNumberOfArgs(int n) {
        this._expectedArgs = n >= 0 ? n : 1;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean bl) {
        this._required = bl;
    }

    public Class getValueType() {
        return this._type;
    }

    public void setValueType(Class clazz) {
        this._type = clazz;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String string) {
        this._value = string;
    }

    public Object resolveValue(String string) throws Exception {
        if (this._resolvedValue == null) {
            this.setValue(string);
            this._resolvedValue = this._type.equals(Boolean.class) || this._type.equals(Boolean.TYPE) ? Boolean.valueOf(this._value != null && this._value.equals("__true__")) : this._resolver.resolve(this._value, this._type);
        }
        return this._resolvedValue;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public void setDefaultValue(String string) {
        this._defaultValue = this._value = string;
    }

    public void setToDefaultValue() {
        this._value = this._defaultValue;
    }

    public Object getResolvedValue() {
        Object object = this._resolvedValue;
        if (this._resolvedValue == null) {
            try {
                object = this.resolveValue(this._value);
            }
            catch (Exception exception) {
                System.err.println("Could not resolve " + this._value + " for switch named " + this._name);
                exception.printStackTrace();
            }
        }
        return object;
    }

    public IArgumentResolver getArgumentResolver() {
        return this._resolver;
    }

    public void setArgumentResolver(IArgumentResolver iArgumentResolver) {
        this._resolver = iArgumentResolver == null ? new DefaultArgumentResolver() : iArgumentResolver;
    }
}

